/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum.distances;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.accum.Norm2;
import org.nd4j.linalg.factory.Nd4j;

public class CosineSimilarity
extends BaseAccumulation {
    private Number constantNormalizedByNorm2X;
    private Number constantNormalizedByNorm2Y;

    public CosineSimilarity() {
    }

    public CosineSimilarity(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public CosineSimilarity(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public CosineSimilarity(INDArray x) {
        super(x);
    }

    public CosineSimilarity(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        this.currentResult = this.currentResult.doubleValue() + result.doubleValue();
        if (this.numProcessed() == this.n()) {
            this.currentResult = this.currentResult.doubleValue() / this.constantNormalizedByNorm2X.doubleValue() / this.constantNormalizedByNorm2Y.doubleValue();
        }
    }

    @Override
    public void update(IComplexNumber result) {
        this.currentComplexResult.addi(result);
        if (this.numProcessed() == this.n()) {
            this.currentComplexResult.set(this.currentComplexResult.realComponent().doubleValue() / this.constantNormalizedByNorm2X.doubleValue() / this.constantNormalizedByNorm2Y.doubleValue(), 0);
        }
    }

    @Override
    public String name() {
        return "cosinesimilarity";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        ++this.numProcessed;
        return origin.mul(other);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        ++this.numProcessed;
        return origin.mul(Float.valueOf(other));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        ++this.numProcessed;
        return origin.mul(other);
    }

    @Override
    public float op(float origin, float other) {
        ++this.numProcessed;
        return origin * other;
    }

    @Override
    public double op(double origin, double other) {
        ++this.numProcessed;
        return origin * other;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        if (this.y() != null) {
            return new CosineSimilarity(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.x.length());
        }
        return new CosineSimilarity(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        if (this.y() != null) {
            return new CosineSimilarity(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.x.length());
        }
        return new CosineSimilarity(this.x.tensorAlongDimension(index, dimension));
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
        this.constantNormalizedByNorm2X = Nd4j.getExecutioner().execAndReturn(new Norm2(x)).currentResult();
        this.constantNormalizedByNorm2Y = Nd4j.getExecutioner().execAndReturn(new Norm2(y)).currentResult();
        this.extraArgs = new Object[]{0.0, this.constantNormalizedByNorm2X, this.constantNormalizedByNorm2Y};
        this.initial = 0.0;
        this.initialComplex = Nd4j.createComplexNumber(0, 0);
    }
}

