/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cache;

import java.util.Arrays;

public class ArrayDescriptor {
    private int hashCode = -1;
    private final DataType dtype;

    public ArrayDescriptor(int[] array) {
        this.hashCode = Arrays.hashCode(array);
        this.dtype = DataType.INT;
    }

    public ArrayDescriptor(float[] array) {
        this.hashCode = Arrays.hashCode(array);
        this.dtype = DataType.FLOAT;
    }

    public ArrayDescriptor(double[] array) {
        this.hashCode = Arrays.hashCode(array);
        this.dtype = DataType.DOUBLE;
    }

    public ArrayDescriptor(long[] array) {
        this.hashCode = Arrays.hashCode(array);
        this.dtype = DataType.LONG;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayDescriptor that = (ArrayDescriptor)o;
        if (this.dtype != that.dtype) {
            return false;
        }
        return this.hashCode == that.hashCode;
    }

    public int hashCode() {
        int result = this.hashCode;
        result = 31 * result + (this.dtype != null ? this.dtype.hashCode() : 0);
        return result;
    }

    public static enum DataType {
        INT,
        FLOAT,
        DOUBLE,
        LONG;

    }
}

