/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ComplexUtil;

public class TanhDerivative
extends BaseTransformOp {
    public TanhDerivative() {
    }

    public TanhDerivative(INDArray x, INDArray z) {
        super(x, z);
    }

    public TanhDerivative(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public TanhDerivative(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public TanhDerivative(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "tanhderivative";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        IComplexNumber tanh = ComplexUtil.tanh(origin);
        return Nd4j.createComplexNumber(1, 1).sub(tanh.mul(tanh));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        IComplexNumber tanh = ComplexUtil.tanh(origin);
        return Nd4j.createComplexNumber(1, 1).sub(tanh.mul(tanh));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        IComplexNumber tanh = ComplexUtil.tanh(origin);
        return Nd4j.createComplexNumber(1, 1).sub(tanh.mul(tanh));
    }

    @Override
    public float op(float origin, float other) {
        double tanh = FastMath.tanh((double)origin);
        return (float)(1.0 - tanh * tanh);
    }

    @Override
    public double op(double origin, double other) {
        double tanh = FastMath.tanh((double)origin);
        return 1.0 - tanh * tanh;
    }

    @Override
    public double op(double origin) {
        double tanh = FastMath.tanh((double)origin);
        return 1.0 - tanh * tanh;
    }

    @Override
    public float op(float origin) {
        double tanh = FastMath.tanh((double)origin);
        return (float)(1.0 - tanh * tanh);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        IComplexNumber tanh = ComplexUtil.tanh(origin);
        return Nd4j.createComplexNumber(1, 1).sub(tanh.mul(tanh));
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new TanhDerivative(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new TanhDerivative(this.x.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new TanhDerivative(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new TanhDerivative(this.x.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

