/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.lossfunctions;

import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.LossCalculation;
import org.nd4j.linalg.ops.transforms.Transforms;

public class LossFunctions {
    public static double score(INDArray labels, LossFunction lossFunction, INDArray z, double l2, double l1, boolean useRegularization) {
        return LossCalculation.builder().l1(l1).lossFunction(lossFunction).l2(l2).labels(labels).z(z).useRegularization(useRegularization).build().score();
    }

    public static double score(INDArray labels, LossFunction lossFunction, INDArray z, double l2, boolean useRegularization) {
        double ret = 0.0;
        double reg = 0.5 * l2;
        if (!Arrays.equals(labels.shape(), z.shape())) {
            throw new IllegalArgumentException("Output and labels must be same length");
        }
        boolean oldEnforce = Nd4j.ENFORCE_NUMERICAL_STABILITY;
        Nd4j.ENFORCE_NUMERICAL_STABILITY = true;
        switch (lossFunction) {
            case CUSTOM: {
                throw new IllegalStateException("Unable to score custom operation. Please define an alternative mechanism");
            }
            case RECONSTRUCTION_CROSSENTROPY: {
                INDArray xEntLogZ2 = Transforms.log(z);
                INDArray xEntOneMinusLabelsOut2 = labels.rsub(1);
                INDArray xEntOneMinusLogOneMinusZ2 = Transforms.log(z).rsubi(1);
                ret = labels.mul(xEntLogZ2).add(xEntOneMinusLabelsOut2).muli(xEntOneMinusLogOneMinusZ2).sum(1).meanNumber().doubleValue();
                break;
            }
            case MCXENT: {
                INDArray sums = Transforms.log(z);
                INDArray columnSums = labels.mul(Transforms.log(sums));
                ret = -columnSums.sumNumber().doubleValue();
                break;
            }
            case XENT: {
                INDArray xEntLogZ = Transforms.log(z);
                INDArray xEntOneMinusLabelsOut = labels.rsub(1);
                INDArray xEntOneMinusLogOneMinusZ = Transforms.log(z).rsubi(1);
                ret = labels.mul(xEntLogZ).add(xEntOneMinusLabelsOut).muli(xEntOneMinusLogOneMinusZ).sum(1).sumNumber().doubleValue();
                break;
            }
            case RMSE_XENT: {
                INDArray rmseXentDiff = labels.sub(z);
                INDArray squaredrmseXentDiff = Transforms.pow(rmseXentDiff, 2.0);
                INDArray sqrt = Transforms.sqrt(squaredrmseXentDiff);
                ret = sqrt.sum(1).sumNumber().doubleValue();
                break;
            }
            case MSE: {
                INDArray mseDelta = labels.sub(z);
                ret = 0.5 * Transforms.pow(mseDelta, 2).sum(1).sumNumber().doubleValue();
                break;
            }
            case EXPLL: {
                INDArray expLLLogZ = Transforms.log(z);
                ret = z.sub(labels.mul(expLLLogZ)).sum(1).sumNumber().doubleValue();
                break;
            }
            case SQUARED_LOSS: {
                ret = Transforms.pow(labels.sub(z), 2).sum(1).sumNumber().doubleValue();
                break;
            }
            case NEGATIVELOGLIKELIHOOD: {
                INDArray sums2 = Transforms.log(z);
                INDArray columnSums2 = labels.mul(Transforms.log(sums2));
                ret = -columnSums2.sumNumber().doubleValue();
            }
        }
        if (useRegularization) {
            ret += reg;
        }
        Nd4j.ENFORCE_NUMERICAL_STABILITY = oldEnforce;
        return ret /= (double)labels.size(0);
    }

    public static enum LossFunction {
        MSE,
        EXPLL,
        XENT,
        MCXENT,
        RMSE_XENT,
        SQUARED_LOSS,
        RECONSTRUCTION_CROSSENTROPY,
        NEGATIVELOGLIKELIHOOD,
        CUSTOM;

    }
}

