/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.Indices;
import org.nd4j.linalg.indexing.IntervalIndex;
import org.nd4j.linalg.indexing.NDArrayIndexAll;
import org.nd4j.linalg.indexing.NDArrayIndexEmpty;
import org.nd4j.linalg.indexing.NewAxis;
import org.nd4j.linalg.indexing.PointIndex;
import org.nd4j.linalg.util.ArrayUtil;

public class NDArrayIndex
implements INDArrayIndex {
    private int[] indices = new int[1];
    private boolean isInterval = false;
    private static NDArrayIndexEmpty EMPTY = new NDArrayIndexEmpty();
    private static NewAxis NEW_AXIS = new NewAxis();

    public static INDArrayIndex point(int point) {
        return new PointIndex(point);
    }

    public static INDArrayIndex[] indexesFor(int ... shape) {
        INDArrayIndex[] ret = new INDArrayIndex[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            ret[i] = NDArrayIndex.point(shape[i]);
        }
        return ret;
    }

    public static int offset(INDArray arr, int ... offsets) {
        return NDArrayIndex.offset(arr.stride(), offsets);
    }

    public static int offset(INDArray arr, INDArrayIndex ... indices) {
        return NDArrayIndex.offset(arr.stride(), Indices.offsets(arr.shape(), indices));
    }

    public static void updateForNewAxes(INDArray arr, INDArrayIndex ... indexes) {
        int numNewAxes = NDArrayIndex.numNewAxis(indexes);
        if (numNewAxes >= 1 && (indexes[0].length() > 1 || indexes[0] instanceof NDArrayIndexAll)) {
            ArrayList<Integer> newShape = new ArrayList<Integer>();
            ArrayList<Integer> newStrides = new ArrayList<Integer>();
            int currDimension = 0;
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] instanceof NewAxis) {
                    newShape.add(1);
                    newStrides.add(0);
                    continue;
                }
                newShape.add(arr.size(currDimension));
                newStrides.add(arr.size(currDimension));
                ++currDimension;
            }
            while (currDimension < arr.rank()) {
                newShape.add(currDimension);
                newStrides.add(currDimension);
                ++currDimension;
            }
            int[] newShapeArr = Ints.toArray(newShape);
            int[] newStrideArr = Ints.toArray(newStrides);
            arr.setShape(newShapeArr);
            arr.setStride(newStrideArr);
        } else if (numNewAxes > 0) {
            int[] newShape = Ints.concat((int[][])new int[][]{ArrayUtil.nTimes(numNewAxes, 1), arr.shape()});
            int[] newStrides = Ints.concat((int[][])new int[][]{new int[numNewAxes], arr.stride()});
            arr.setShape(newShape);
            arr.setStride(newStrides);
        }
    }

    public static int offset(int[] strides, int[] offsets) {
        int ret = 0;
        if (ArrayUtil.prod(offsets) == 1) {
            for (int i = 0; i < offsets.length; ++i) {
                ret += offsets[i] * strides[i];
            }
        } else {
            for (int i = 0; i < offsets.length; ++i) {
                ret += offsets[i] * strides[i];
            }
        }
        return ret;
    }

    public static INDArrayIndex[] nTimes(INDArrayIndex copy, int n) {
        INDArrayIndex[] ret = new INDArrayIndex[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = copy;
        }
        return ret;
    }

    public NDArrayIndex(int ... indices) {
        this.indices = indices;
    }

    public static INDArrayIndex empty() {
        return EMPTY;
    }

    public static INDArrayIndex all() {
        return new NDArrayIndexAll(true);
    }

    public static INDArrayIndex newAxis() {
        return NEW_AXIS;
    }

    public static INDArrayIndex[] resolve(INDArray arr, INDArrayIndex ... intendedIndexes) {
        return NDArrayIndex.resolve(NDArrayIndex.allFor(arr), intendedIndexes);
    }

    public static int numPoints(INDArrayIndex ... indexes) {
        int ret = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (!(indexes[i] instanceof PointIndex)) continue;
            ++ret;
        }
        return ret;
    }

    public static INDArrayIndex[] resolve(int[] shape, INDArrayIndex ... intendedIndexes) {
        if (intendedIndexes.length >= shape.length || Shape.isVector(shape) && intendedIndexes.length == 1) {
            if (Shape.isRowVectorShape(shape) && intendedIndexes.length == 1 && intendedIndexes[0] instanceof IntervalIndex) {
                INDArrayIndex[] ret = new INDArrayIndex[]{NDArrayIndex.point(0), intendedIndexes[0]};
                return ret;
            }
            return intendedIndexes;
        }
        ArrayList<INDArrayIndex> retList = new ArrayList<INDArrayIndex>();
        int numNewAxes = 0;
        if (Shape.isMatrix(shape) && intendedIndexes.length == 1) {
            retList.add(intendedIndexes[0]);
            retList.add(NDArrayIndex.all());
        } else {
            for (int i = 0; i < intendedIndexes.length; ++i) {
                retList.add(intendedIndexes[i]);
                if (!(intendedIndexes[i] instanceof NewAxis)) continue;
                ++numNewAxes;
            }
        }
        int length = shape.length + numNewAxes;
        while (retList.size() < length) {
            retList.add(NDArrayIndex.all());
        }
        return retList.toArray(new INDArrayIndex[retList.size()]);
    }

    public static INDArrayIndex[] resolve(INDArrayIndex[] allIndex, INDArrayIndex ... intendedIndexes) {
        int numNewAxes = NDArrayIndex.numNewAxis(intendedIndexes);
        Object[] all = new INDArrayIndex[allIndex.length + numNewAxes];
        Arrays.fill(all, NDArrayIndex.all());
        for (int i = 0; i < allIndex.length && i < intendedIndexes.length; ++i) {
            if (intendedIndexes[i] instanceof NDArrayIndex) {
                NDArrayIndex idx = (NDArrayIndex)intendedIndexes[i];
                if (idx.indices.length == 1) {
                    intendedIndexes[i] = new PointIndex(idx.indices[0]);
                }
            }
            all[i] = intendedIndexes[i];
        }
        return all;
    }

    public static int numNewAxis(INDArrayIndex ... axes) {
        int ret = 0;
        for (INDArrayIndex index : axes) {
            if (!(index instanceof NewAxis)) continue;
            ++ret;
        }
        return ret;
    }

    public static INDArrayIndex[] allFor(INDArray arr) {
        INDArrayIndex[] ret = new INDArrayIndex[arr.rank()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = NDArrayIndex.all();
        }
        return ret;
    }

    public static INDArrayIndex[] createCoveringShape(int[] shape) {
        INDArrayIndex[] ret = new INDArrayIndex[shape.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = NDArrayIndex.interval(0, shape[i]);
        }
        return ret;
    }

    public static INDArrayIndex[] rangeOfLength(INDArrayIndex[] indexes) {
        INDArrayIndex[] indexesRet = new INDArrayIndex[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexesRet[i] = NDArrayIndex.interval(0, indexes[i].length());
        }
        return indexesRet;
    }

    public static INDArrayIndex[] create(INDArray index) {
        if (index.isMatrix()) {
            INDArrayIndex[] ret = new NDArrayIndex[index.rows()];
            for (int i = 0; i < index.rows(); ++i) {
                INDArray row = index.getRow(i);
                int[] nums = new int[index.getRow(i).columns()];
                for (int j = 0; j < row.columns(); ++j) {
                    nums[j] = (int)row.getFloat(j);
                }
                NDArrayIndex idx = new NDArrayIndex(nums);
                ret[i] = idx;
            }
            return ret;
        }
        if (index.isVector()) {
            int[] indices = ArrayUtil.toInts(index);
            return new NDArrayIndex[]{new NDArrayIndex(indices)};
        }
        throw new IllegalArgumentException("Passed in ndarray must be a matrix or a vector");
    }

    public static INDArrayIndex interval(int begin, int stride, int end) {
        if (Math.abs(begin - end) < 1) {
            ++end;
        }
        if (stride > 1 && Math.abs(begin - end) == 1) {
            end *= stride;
        }
        return NDArrayIndex.interval(begin, stride, end, false);
    }

    public static INDArrayIndex interval(int begin, int stride, int end, boolean inclusive) {
        assert (begin <= end) : "Beginning index in range must be less than end";
        IntervalIndex index = new IntervalIndex(inclusive, stride);
        index.init(begin, end);
        return index;
    }

    public static INDArrayIndex interval(int begin, int end) {
        return NDArrayIndex.interval(begin, 1, end, false);
    }

    public static INDArrayIndex interval(int begin, int end, boolean inclusive) {
        return NDArrayIndex.interval(begin, 1, end, inclusive);
    }

    @Override
    public int end() {
        if (this.indices != null && this.indices.length > 0) {
            return this.indices[this.indices.length - 1];
        }
        return 0;
    }

    @Override
    public int offset() {
        if (this.indices.length < 1) {
            return 0;
        }
        return this.indices[0];
    }

    @Override
    public int length() {
        return this.indices.length;
    }

    @Override
    public int stride() {
        return 1;
    }

    @Override
    public int current() {
        return 0;
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public int next() {
        return 0;
    }

    @Override
    public void reverse() {
        ArrayUtil.reverse(this.indices);
    }

    public String toString() {
        return "NDArrayIndex{indices=" + Arrays.toString(this.indices) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof INDArrayIndex)) {
            return false;
        }
        NDArrayIndex that = (NDArrayIndex)o;
        return Arrays.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Arrays.hashCode(this.indices);
    }

    @Override
    public boolean isInterval() {
        return this.isInterval;
    }

    @Override
    public void setInterval(boolean isInterval) {
        this.isInterval = isInterval;
    }

    @Override
    public void init(INDArray arr, int begin, int dimension) {
    }

    @Override
    public void init(INDArray arr, int dimension) {
    }

    @Override
    public void init(int begin, int end) {
    }

    @Override
    public void reset() {
    }
}

