/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;

public class IntervalIndex
implements INDArrayIndex {
    protected int begin;
    protected int end;
    protected boolean inclusive;
    protected int stride = 1;
    protected int index = 0;
    protected int length = 0;

    public IntervalIndex(boolean inclusive, int stride) {
        this.inclusive = inclusive;
        this.stride = stride;
    }

    @Override
    public int end() {
        return this.end;
    }

    @Override
    public int offset() {
        return this.begin;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int stride() {
        return this.stride;
    }

    @Override
    public int current() {
        return this.index;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.end();
    }

    @Override
    public int next() {
        int ret = this.index;
        this.index += this.stride;
        return ret;
    }

    @Override
    public void reverse() {
        int oldBegin;
        int oldEnd = this.end;
        this.end = oldBegin = this.begin;
        this.begin = oldEnd;
    }

    @Override
    public boolean isInterval() {
        return true;
    }

    @Override
    public void setInterval(boolean isInterval) {
    }

    @Override
    public void init(INDArray arr, int begin, int dimension) {
        this.begin = begin;
        this.index = begin;
        this.end = this.inclusive ? arr.size(dimension) + 1 : arr.size(dimension);
        for (int i = begin; i < this.end; i += this.stride) {
            ++this.length;
        }
    }

    @Override
    public void init(INDArray arr, int dimension) {
        this.init(arr, 0, dimension);
    }

    @Override
    public void init(int begin, int end) {
        this.begin = begin;
        this.index = begin;
        this.end = this.inclusive ? end + 1 : end;
        for (int i = begin; i < end; i += this.stride) {
            ++this.length;
        }
    }

    @Override
    public void reset() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntervalIndex)) {
            return false;
        }
        IntervalIndex that = (IntervalIndex)o;
        if (this.begin != that.begin) {
            return false;
        }
        if (this.end != that.end) {
            return false;
        }
        if (this.inclusive != that.inclusive) {
            return false;
        }
        if (this.stride != that.stride) {
            return false;
        }
        return this.index == that.index;
    }

    public int hashCode() {
        int result = this.begin;
        result = 31 * result + this.end;
        result = 31 * result + (this.inclusive ? 1 : 0);
        result = 31 * result + this.stride;
        result = 31 * result + this.index;
        return result;
    }
}

