/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class IAMax
extends BaseAccumulation {
    private int currIndexOfMax = 0;

    public IAMax() {
    }

    public IAMax(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public IAMax(INDArray x) {
        super(x);
    }

    public IAMax(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        this.currIndexOfMax = Nd4j.getBlasWrapper().iamax(this.x) / this.x.length();
    }

    @Override
    public void update(IComplexNumber result) {
        IComplexNDArray complexX = (IComplexNDArray)this.x;
        this.currentComplexResult = Nd4j.createComplexNumber(Nd4j.getBlasWrapper().iamax(this.x), 0.0);
    }

    @Override
    public String name() {
        return "iamax";
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
        this.exec();
    }

    @Override
    public void exec(int ... dimensions) {
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new IAMax(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new IAMax(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public void exec() {
        int idx = 0;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.x.length(); ++i) {
            double val = this.x.getDouble(i);
            if (!(val > max)) continue;
            max = val;
            idx = i;
        }
        this.currentResult = idx;
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new IAMax(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new IAMax(this.x.tensorAlongDimension(index, dimension));
    }
}

