/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.executioner;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class Loop {
    private static final int CPUs = Runtime.getRuntime().availableProcessors();
    static ExecutorService executor = Executors.newFixedThreadPool(CPUs, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });

    public static void withIndex(int start, int stop, final Each body) {
        final CountDownLatch latch = new CountDownLatch(CPUs);
        int i = start;
        while (i < stop) {
            final int lo = i++;
            final int hi = i < stop ? i : stop;
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = lo; i < hi; ++i) {
                        body.run(i);
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public static interface Each {
        public void run(int var1);
    }
}

