/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.params;

import org.nd4j.linalg.api.iter.NdIndexIterator;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class GemmParams {
    private int lda;
    private int ldb;
    private int ldc;
    private int m;
    private int n;
    private int k;
    private INDArray a;
    private INDArray b;
    private INDArray c;

    public GemmParams(INDArray a, INDArray b, INDArray c) {
        if (b.columns() != c.columns()) {
            throw new IllegalArgumentException("B columns must match c columns");
        }
        if (a.rows() != c.rows()) {
            throw new IllegalArgumentException("A rows must equal c rows");
        }
        if (a.ordering() != b.ordering()) {
            int[] next;
            NdIndexIterator iter;
            if (a.ordering() != 'f') {
                INDArray rearrangedA = Nd4j.create(a.shape(), 'f');
                iter = new NdIndexIterator('c', rearrangedA.shape());
                while (iter.hasNext()) {
                    next = iter.next();
                    rearrangedA.putScalar(next, a.getDouble(next));
                }
                a = rearrangedA;
            }
            if (b.ordering() != 'f') {
                INDArray rearrangedB = Nd4j.create(b.shape(), 'f');
                iter = new NdIndexIterator('c', rearrangedB.shape());
                while (iter.hasNext()) {
                    next = iter.next();
                    rearrangedB.putScalar(next, b.getDouble(next));
                }
                b = rearrangedB;
            }
        }
        this.a = a;
        this.b = b;
        this.c = c;
        this.m = a.rows();
        this.n = b.columns();
        this.k = a.columns();
        if (a.ordering() == 'c' && b.ordering() == 'c') {
            int oldN = this.n;
            int oldM = this.m;
            this.m = oldN;
            this.n = oldM;
            this.a = b;
            this.b = a;
        }
        this.lda = Math.max(1, this.m);
        this.ldb = Math.max(1, this.k);
        this.ldc = Math.max(1, this.m);
        if (this.unevenStrides(a)) {
            this.a = a.dup();
        }
        if (this.unevenStrides(b)) {
            this.b = b.dup();
        }
        this.validate();
    }

    protected boolean unevenStrides(INDArray arr) {
        return arr.ordering() == 'f' && arr.offset() > 0;
    }

    private void validate() {
        if (this.m < 0) {
            throw new IllegalStateException("M must be >= 0");
        }
        if (this.n < 0) {
            throw new IllegalStateException("N must be >= 0");
        }
        if (this.k < 0) {
            throw new IllegalStateException("K must be at least 0");
        }
    }

    public int getLda() {
        return this.lda;
    }

    public int getLdb() {
        return this.ldb;
    }

    public int getLdc() {
        return this.ldc;
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public INDArray getA() {
        return this.a;
    }

    public INDArray getB() {
        return this.b;
    }

    public INDArray getC() {
        return this.c;
    }

    public void setLda(int lda) {
        this.lda = lda;
    }

    public void setLdb(int ldb) {
        this.ldb = ldb;
    }

    public void setLdc(int ldc) {
        this.ldc = ldc;
    }

    public void setM(int m) {
        this.m = m;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setK(int k) {
        this.k = k;
    }

    public void setA(INDArray a) {
        this.a = a;
    }

    public void setB(INDArray b) {
        this.b = b;
    }

    public void setC(INDArray c) {
        this.c = c;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GemmParams)) {
            return false;
        }
        GemmParams other = (GemmParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLda() != other.getLda()) {
            return false;
        }
        if (this.getLdb() != other.getLdb()) {
            return false;
        }
        if (this.getLdc() != other.getLdc()) {
            return false;
        }
        if (this.getM() != other.getM()) {
            return false;
        }
        if (this.getN() != other.getN()) {
            return false;
        }
        if (this.getK() != other.getK()) {
            return false;
        }
        INDArray this$a = this.getA();
        INDArray other$a = other.getA();
        if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
            return false;
        }
        INDArray this$b = this.getB();
        INDArray other$b = other.getB();
        if (this$b == null ? other$b != null : !this$b.equals(other$b)) {
            return false;
        }
        INDArray this$c = this.getC();
        INDArray other$c = other.getC();
        return !(this$c == null ? other$c != null : !this$c.equals(other$c));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GemmParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLda();
        result = result * 59 + this.getLdb();
        result = result * 59 + this.getLdc();
        result = result * 59 + this.getM();
        result = result * 59 + this.getN();
        result = result * 59 + this.getK();
        INDArray $a = this.getA();
        result = result * 59 + ($a == null ? 0 : $a.hashCode());
        INDArray $b = this.getB();
        result = result * 59 + ($b == null ? 0 : $b.hashCode());
        INDArray $c = this.getC();
        result = result * 59 + ($c == null ? 0 : $c.hashCode());
        return result;
    }

    public String toString() {
        return "GemmParams(lda=" + this.getLda() + ", ldb=" + this.getLdb() + ", ldc=" + this.getLdc() + ", m=" + this.getM() + ", n=" + this.getN() + ", k=" + this.getK() + ", a=" + this.getA() + ", b=" + this.getB() + ", c=" + this.getC() + ")";
    }
}

