/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scalar;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseScalarOp;
import org.nd4j.linalg.api.ops.Op;

public class ScalarReverseDivision
extends BaseScalarOp {
    public ScalarReverseDivision() {
    }

    public ScalarReverseDivision(INDArray x, INDArray y, INDArray z, int n, Number num) {
        super(x, y, z, n, num);
    }

    public ScalarReverseDivision(INDArray x, Number num) {
        super(x, num);
    }

    public ScalarReverseDivision(INDArray x, INDArray y, INDArray z, int n, IComplexNumber num) {
        super(x, y, z, n, num);
    }

    public ScalarReverseDivision(INDArray x, IComplexNumber num) {
        super(x, num);
    }

    @Override
    public String name() {
        return "rdiv_scalar";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        if (this.complexNumber != null) {
            return this.complexNumber.rdiv(origin);
        }
        return this.complexNumber.rdiv(this.num);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        if (this.complexNumber != null) {
            return origin.rdiv(this.complexNumber);
        }
        return this.complexNumber.rdiv(this.num);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        if (this.complexNumber != null) {
            return origin.div(this.complexNumber);
        }
        return this.complexNumber.rdiv(this.num);
    }

    @Override
    public float op(float origin, float other) {
        return this.num.floatValue() / origin;
    }

    @Override
    public double op(double origin, double other) {
        return this.num.doubleValue() / origin;
    }

    @Override
    public double op(double origin) {
        return this.num.doubleValue() / origin;
    }

    @Override
    public float op(float origin) {
        return this.num.floatValue() / origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        if (this.complexNumber != null) {
            return origin.rdiv(this.complexNumber);
        }
        return this.complexNumber.rdiv(this.num);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        if (this.num != null) {
            return new ScalarReverseDivision(this.x.vectorAlongDimension(index, dimension), this.num);
        }
        return new ScalarReverseDivision(this.x.vectorAlongDimension(index, dimension), this.complexNumber);
    }
}

