/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class Norm1
extends BaseAccumulation {
    public Norm1() {
    }

    public Norm1(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Norm1(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public Norm1(INDArray x) {
        super(x);
    }

    public Norm1(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        this.currentResult = this.currentResult.doubleValue() + FastMath.abs((double)result.doubleValue());
        ++this.numProcessed;
    }

    @Override
    public void update(IComplexNumber result) {
        this.currentComplexResult.addi(result);
        ++this.numProcessed;
    }

    @Override
    public Number zero() {
        return 0.0;
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(0.0, 0.0);
    }

    @Override
    public String name() {
        return "norm1";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Norm1(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Norm1(this.x.vectorAlongDimension(index, dimension));
    }
}

