/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.instrumentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.instrumentation.DataBufferLogEntry;
import org.nd4j.linalg.api.instrumentation.Instrumentation;
import org.nd4j.linalg.api.instrumentation.LogEntry;
import org.nd4j.linalg.api.ndarray.INDArray;

public class InMemoryInstrumentation
implements Instrumentation {
    private List<LogEntry> entries = Collections.synchronizedList(new ArrayList());
    private List<DataBufferLogEntry> dataBufferLogEntries = Collections.synchronizedList(new ArrayList());
    private ExecutorService executorService = Executors.newFixedThreadPool(8);
    private Map<String, Collection<LogEntry>> logEntries = new ConcurrentHashMap<String, Collection<LogEntry>>();

    @Override
    public void log(final INDArray toLog, final String status) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                LogEntry entry = new LogEntry(toLog, status);
                InMemoryInstrumentation.this.entries.add(entry);
            }
        });
    }

    @Override
    public void log(final DataBuffer buffer, final String status) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                InMemoryInstrumentation.this.dataBufferLogEntries.add(new DataBufferLogEntry(buffer, status));
            }
        });
    }

    @Override
    public void log(final INDArray toLog) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                InMemoryInstrumentation.this.entries.add(new LogEntry(toLog));
            }
        });
    }

    @Override
    public void log(final DataBuffer buffer) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                InMemoryInstrumentation.this.dataBufferLogEntries.add(new DataBufferLogEntry(buffer));
            }
        });
    }

    @Override
    public Collection<LogEntry> getStillAlive() {
        HashSet<LogEntry> ret = new HashSet<LogEntry>();
        for (String s : this.logEntries.keySet()) {
            Collection<LogEntry> coll = this.logEntries.get(s);
            boolean foundDestroyed = false;
            LogEntry created = null;
            for (LogEntry entry : coll) {
                if (entry.getStatus().equals("destroyed")) {
                    foundDestroyed = true;
                }
                if (!entry.getStatus().equals("created")) continue;
                created = entry;
            }
            if (foundDestroyed) continue;
            if (created != null) {
                ret.add(created);
                continue;
            }
            throw new IllegalStateException("Unable to add a non created entry");
        }
        return ret;
    }

    @Override
    public Collection<LogEntry> getDestroyed() {
        HashSet<LogEntry> ret = new HashSet<LogEntry>();
        for (String s : this.logEntries.keySet()) {
            Collection<LogEntry> coll = this.logEntries.get(s);
            for (LogEntry entry : coll) {
                if (!entry.getStatus().equals("destroyed")) continue;
                ret.add(entry);
            }
        }
        return ret;
    }

    @Override
    public boolean isDestroyed(String id) {
        Collection<LogEntry> logged = this.logEntries.get(id);
        if (logged == null) {
            throw new IllegalArgumentException("No key found " + id);
        }
        return logged.size() == 2;
    }

    public List<DataBufferLogEntry> getDataBufferLogEntries() {
        return this.dataBufferLogEntries;
    }

    public void setDataBufferLogEntries(List<DataBufferLogEntry> dataBufferLogEntries) {
        this.dataBufferLogEntries = dataBufferLogEntries;
    }

    public List<LogEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<LogEntry> entries) {
        this.entries = entries;
    }
}

