/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import com.google.common.base.Function;
import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.convolution.ConvolutionInstance;
import org.nd4j.linalg.convolution.DefaultConvolutionInstance;
import org.nd4j.linalg.factory.BlasWrapper;
import org.nd4j.linalg.factory.NDArrayFactory;
import org.nd4j.linalg.fft.DefaultFFTInstance;
import org.nd4j.linalg.fft.FFTInstance;
import org.nd4j.linalg.indexing.BooleanIndexing;
import org.nd4j.linalg.indexing.conditions.Conditions;
import org.nd4j.linalg.indexing.functions.Value;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.Shape;
import org.springframework.core.io.ClassPathResource;

public class Nd4j {
    private static Class<? extends BlasWrapper> blasWrapperClazz;
    private static Class<? extends NDArrayFactory> ndArrayFactoryClazz;
    private static Class<? extends FFTInstance> fftInstanceClazz;
    private static Class<? extends ConvolutionInstance> convolutionInstanceClazz;
    private static BlasWrapper BLAS_WRAPPER_INSTANCE;
    public static final String LINALG_PROPS = "/nd4j.properties";
    public static final String REAL_CLASS_PROP = "real.class";
    public static final String COMPLEX_CLASS_PROP = "complex.class";
    public static final String NUMERICAL_STABILITY = "force.stability";
    public static final String FFT_OPS = "fft";
    public static final String CONVOLUTION_OPS = "convops";
    public static final String DTYPE = "dtype";
    public static final String BLAS_OPS = "blas.ops";
    public static int dtype;
    public static char ORDER;
    public static final String ORDER_KEY = "ndarray.order";
    public static final String NDARRAY_FACTORY_CLASS = "ndarrayfactory.class";
    private static NDArrayFactory INSTANCE;
    private static FFTInstance FFT_INSTANCE;
    private static ConvolutionInstance CONVOLUTION_INSTANCE;
    private static Properties props;
    public static final IComplexNumber UNIT;
    public static final IComplexNumber ZERO;
    public static final IComplexNumber NEG_UNIT;
    public static double EPS_THRESHOLD;
    public static int MAX_ELEMENTS_PER_SLICE;
    public static int MAX_SLICES_TO_PRINT;
    public static boolean ENFORCE_NUMERICAL_STABILITY;

    public static void setConvolution(ConvolutionInstance convolutionInstance) {
        if (convolutionInstance == null) {
            throw new IllegalArgumentException("No null instances allowed");
        }
        CONVOLUTION_INSTANCE = convolutionInstance;
    }

    public static ConvolutionInstance getConvolution() {
        return CONVOLUTION_INSTANCE;
    }

    public static FFTInstance getFFt() {
        return FFT_INSTANCE;
    }

    public static void setFft(FFTInstance fftInstance) {
        if (fftInstance == null) {
            throw new IllegalArgumentException("No null instances allowed");
        }
        FFT_INSTANCE = fftInstance;
    }

    public static void setParams(INDArray theta, Collection<INDArray> ... matrices) {
        int index = 0;
        for (Collection<INDArray> matrixCollection : matrices) {
            for (INDArray matrix : matrixCollection) {
                INDArray linear = matrix.linearView();
                for (int i = 0; i < matrix.length(); ++i) {
                    linear.putScalar(i, theta.getDouble(index));
                    ++index;
                }
            }
        }
        if (index != theta.length()) {
            throw new AssertionError((Object)"Did not entirely use the theta vector");
        }
    }

    public static void setParams(INDArray theta, Iterator<? extends INDArray> ... matrices) {
        int index = 0;
        for (Iterator<? extends INDArray> matrixIterator : matrices) {
            while (matrixIterator.hasNext()) {
                INDArray matrix = matrixIterator.next().linearView();
                for (int i = 0; i < matrix.length(); ++i) {
                    matrix.putScalar(i, theta.getDouble(index));
                    ++index;
                }
            }
        }
        if (index != theta.length()) {
            throw new AssertionError((Object)"Did not entirely use the theta vector");
        }
    }

    public static NDArrayFactory factory() {
        return INSTANCE;
    }

    public static INDArray cumsum(INDArray compute) {
        return compute.cumsum(Integer.MAX_VALUE);
    }

    public static INDArray max(INDArray compute) {
        return compute.max(Integer.MAX_VALUE);
    }

    public static INDArray min(INDArray compute) {
        return compute.min(Integer.MAX_VALUE);
    }

    public static INDArray prod(INDArray compute) {
        return compute.prod(Integer.MAX_VALUE);
    }

    public static INDArray normmax(INDArray compute) {
        return compute.normmax(Integer.MAX_VALUE);
    }

    public static INDArray norm2(INDArray compute) {
        return compute.norm2(Integer.MAX_VALUE);
    }

    public static INDArray norm1(INDArray compute) {
        return compute.norm1(Integer.MAX_VALUE);
    }

    public static INDArray std(INDArray compute) {
        return compute.std(Integer.MAX_VALUE);
    }

    public static INDArray var(INDArray compute) {
        return compute.var(Integer.MAX_VALUE);
    }

    public static INDArray sum(INDArray compute) {
        return compute.sum(Integer.MAX_VALUE);
    }

    public static INDArray mean(INDArray compute) {
        return compute.mean(Integer.MAX_VALUE);
    }

    public static IComplexNDArray cumsum(IComplexNDArray compute) {
        return compute.cumsum(Integer.MAX_VALUE);
    }

    public static IComplexNDArray max(IComplexNDArray compute) {
        return compute.max(Integer.MAX_VALUE);
    }

    public static IComplexNDArray min(IComplexNDArray compute) {
        return compute.min(Integer.MAX_VALUE);
    }

    public static IComplexNDArray prod(IComplexNDArray compute) {
        return compute.prod(Integer.MAX_VALUE);
    }

    public static IComplexNDArray normmax(IComplexNDArray compute) {
        return compute.normmax(Integer.MAX_VALUE);
    }

    public static IComplexNDArray norm2(IComplexNDArray compute) {
        return compute.norm2(Integer.MAX_VALUE);
    }

    public static IComplexNDArray norm1(IComplexNDArray compute) {
        return compute.norm1(Integer.MAX_VALUE);
    }

    public static IComplexNDArray std(IComplexNDArray compute) {
        return compute.std(Integer.MAX_VALUE);
    }

    public static IComplexNDArray var(IComplexNDArray compute) {
        return compute.var(Integer.MAX_VALUE);
    }

    public static IComplexNDArray sum(IComplexNDArray compute) {
        return compute.sum(Integer.MAX_VALUE);
    }

    public static IComplexNDArray mean(IComplexNDArray compute) {
        return compute.mean(Integer.MAX_VALUE);
    }

    public static INDArray cumsum(INDArray compute, int dimension) {
        return compute.cumsum(dimension);
    }

    public static INDArray max(INDArray compute, int dimension) {
        return compute.max(dimension);
    }

    public static INDArray min(INDArray compute, int dimension) {
        return compute.min(dimension);
    }

    public static INDArray prod(INDArray compute, int dimension) {
        return compute.prod(dimension);
    }

    public static INDArray normmax(INDArray compute, int dimension) {
        return compute.normmax(dimension);
    }

    public static INDArray norm2(INDArray compute, int dimension) {
        return compute.norm2(dimension);
    }

    public static INDArray norm1(INDArray compute, int dimension) {
        return compute.norm1(dimension);
    }

    public static INDArray std(INDArray compute, int dimension) {
        return compute.std(dimension);
    }

    public static INDArray var(INDArray compute, int dimension) {
        return compute.var(dimension);
    }

    public static INDArray sum(INDArray compute, int dimension) {
        return compute.sum(dimension);
    }

    public static INDArray mean(INDArray compute, int dimension) {
        return compute.mean(dimension);
    }

    public static IComplexNDArray cumsum(IComplexNDArray compute, int dimension) {
        return compute.cumsum(dimension);
    }

    public static IComplexNDArray max(IComplexNDArray compute, int dimension) {
        return compute.max(dimension);
    }

    public static IComplexNDArray min(IComplexNDArray compute, int dimension) {
        return compute.min(dimension);
    }

    public static IComplexNDArray prod(IComplexNDArray compute, int dimension) {
        return compute.prod(dimension);
    }

    public static IComplexNDArray normmax(IComplexNDArray compute, int dimension) {
        return compute.normmax(dimension);
    }

    public static IComplexNDArray norm2(IComplexNDArray compute, int dimension) {
        return compute.norm2(dimension);
    }

    public static IComplexNDArray norm1(IComplexNDArray compute, int dimension) {
        return compute.norm1(dimension);
    }

    public static IComplexNDArray std(IComplexNDArray compute, int dimension) {
        return compute.std(dimension);
    }

    public static IComplexNDArray var(IComplexNDArray compute, int dimension) {
        return compute.var(dimension);
    }

    public static IComplexNDArray sum(IComplexNDArray compute, int dimension) {
        return compute.sum(dimension);
    }

    public static IComplexNDArray mean(IComplexNDArray compute, int dimension) {
        return compute.mean(dimension);
    }

    public static DataBuffer createBuffer(int[] shape, int type) {
        int length = ArrayUtil.prod(shape);
        return type == 0 ? Nd4j.createBuffer(new double[length]) : Nd4j.createBuffer(new float[length]);
    }

    public static DataBuffer createBuffer(int[] shape) {
        int length = ArrayUtil.prod(shape);
        return Nd4j.createBuffer(length);
    }

    public static DataBuffer createBuffer(long length) {
        if (Nd4j.dataType() == 1) {
            return Nd4j.createBuffer(new float[(int)length]);
        }
        return Nd4j.createBuffer(new double[(int)length]);
    }

    public static DataBuffer createBuffer(float[] data) {
        return INSTANCE.createBuffer(data);
    }

    public static DataBuffer createBuffer(double[] data) {
        return INSTANCE.createBuffer(data);
    }

    public static <E> DataBuffer createBuffer(E[] data) {
        throw new UnsupportedOperationException();
    }

    public static void setFactory(NDArrayFactory factory) {
        INSTANCE = factory;
    }

    public static void setBlasWrapper(BlasWrapper factory) {
        BLAS_WRAPPER_INSTANCE = factory;
    }

    public static Character order() {
        return Character.valueOf(Nd4j.factory().order());
    }

    public static int dataType() {
        return dtype;
    }

    public static BlasWrapper getBlasWrapper() {
        return BLAS_WRAPPER_INSTANCE;
    }

    public static IComplexNDArray createComplex(INDArray real, INDArray imag) {
        assert (Shape.shapeEquals(real.shape(), imag.shape()));
        IComplexNDArray ret = Nd4j.createComplex(real.shape());
        INDArray realLinear = real.linearView();
        INDArray imagLinear = imag.linearView();
        IComplexNDArray retLinear = ret.linearView();
        for (int i = 0; i < ret.length(); ++i) {
            retLinear.putScalar(i, Nd4j.createComplexNumber(realLinear.getDouble(i), imagLinear.getDouble(i)));
        }
        return ret;
    }

    public static IComplexNDArray repeat(IComplexNDArray n, int num) {
        ArrayList<IComplexNDArray> list = new ArrayList<IComplexNDArray>();
        for (int i = 0; i < num; ++i) {
            list.add(n.dup());
        }
        return Nd4j.createComplex(list, Ints.concat((int[][])new int[][]{{num}, n.shape()}));
    }

    public static INDArray[] sortWithIndices(IComplexNDArray ndarray, int dimension, boolean ascending) {
        INDArray indices = Nd4j.create(ndarray.shape());
        INDArray[] ret = new INDArray[2];
        for (int i = 0; i < ndarray.vectorsAlongDimension(dimension); ++i) {
            int j;
            IComplexNDArray vec = ndarray.vectorAlongDimension(i, dimension);
            INDArray indexVector = indices.vectorAlongDimension(i, dimension);
            final IComplexNumber[] data = new IComplexNumber[vec.length()];
            Double[] index = new Double[vec.length()];
            for (j = 0; j < vec.length(); ++j) {
                data[j] = vec.getComplex(j);
                index[j] = j;
            }
            if (ascending) {
                Arrays.sort(index, new Comparator<Double>(){

                    @Override
                    public int compare(Double o1, Double o2) {
                        int idx1 = (int)o1.doubleValue();
                        int idx2 = (int)o2.doubleValue();
                        return Double.compare(data[idx1].absoluteValue().doubleValue(), data[idx2].absoluteValue().doubleValue());
                    }
                });
            } else {
                Arrays.sort(index, new Comparator<Double>(){

                    @Override
                    public int compare(Double o1, Double o2) {
                        int idx1 = (int)o1.doubleValue();
                        int idx2 = (int)o2.doubleValue();
                        return -Double.compare(data[idx1].absoluteValue().doubleValue(), data[idx2].absoluteValue().doubleValue());
                    }
                });
            }
            for (j = 0; j < vec.length(); ++j) {
                vec.putScalar(j, data[(int)index[j].doubleValue()]);
                indexVector.putScalar(j, (double)index[j]);
            }
        }
        ret[0] = indices;
        ret[1] = ndarray;
        return ret;
    }

    public static INDArray[] sortWithIndices(INDArray ndarray, int dimension, boolean ascending) {
        INDArray indices = Nd4j.create(ndarray.shape());
        INDArray[] ret = new INDArray[2];
        for (int i = 0; i < ndarray.vectorsAlongDimension(dimension); ++i) {
            int j;
            INDArray vec = ndarray.vectorAlongDimension(i, dimension);
            INDArray indexVector = indices.vectorAlongDimension(i, dimension);
            final Double[] data = new Double[vec.length()];
            Double[] index = new Double[vec.length()];
            for (j = 0; j < vec.length(); ++j) {
                data[j] = vec.getDouble(j);
                index[j] = j;
            }
            Arrays.sort(index, new Comparator<Double>(){

                @Override
                public int compare(Double o1, Double o2) {
                    int o = (int)o1.doubleValue();
                    int oo2 = (int)o2.doubleValue();
                    return Double.compare(data[o], data[oo2]);
                }
            });
            if (ascending) {
                for (j = 0; j < vec.length(); ++j) {
                    vec.putScalar(j, (double)data[(int)index[j].doubleValue()]);
                    indexVector.putScalar(j, (double)index[j]);
                }
                continue;
            }
            int count = data.length - 1;
            for (int j2 = 0; j2 < vec.length(); ++j2) {
                int currCount2 = count--;
                vec.putScalar(j2, (double)data[(int)index[currCount2].doubleValue()]);
                indexVector.putScalar(j2, (double)index[currCount2]);
            }
        }
        ret[0] = indices;
        ret[1] = ndarray;
        return ret;
    }

    public static IComplexNDArray sort(IComplexNDArray ndarray, int dimension, boolean ascending) {
        for (int i = 0; i < ndarray.vectorsAlongDimension(dimension); ++i) {
            int j;
            IComplexNDArray vec = ndarray.vectorAlongDimension(i, dimension);
            IComplexNumber[] data = new IComplexNumber[vec.length()];
            for (j = 0; j < vec.length(); ++j) {
                data[j] = vec.getComplex(j);
            }
            if (ascending) {
                Arrays.sort(data, new Comparator<IComplexNumber>(){

                    @Override
                    public int compare(IComplexNumber o1, IComplexNumber o2) {
                        return Double.compare(o1.asDouble().absoluteValue().doubleValue(), o2.asDouble().absoluteValue().doubleValue());
                    }
                });
            } else {
                Arrays.sort(data, new Comparator<IComplexNumber>(){

                    @Override
                    public int compare(IComplexNumber o1, IComplexNumber o2) {
                        return -Double.compare(o1.asDouble().absoluteValue().doubleValue(), o2.asDouble().absoluteValue().doubleValue());
                    }
                });
            }
            for (j = 0; j < vec.length(); ++j) {
                vec.putScalar(j, data[j]);
            }
        }
        return ndarray;
    }

    public static INDArray sort(INDArray ndarray, int dimension, boolean ascending) {
        for (int i = 0; i < ndarray.vectorsAlongDimension(dimension); ++i) {
            int j;
            INDArray vec = ndarray.vectorAlongDimension(i, dimension);
            double[] data = new double[vec.length()];
            for (j = 0; j < vec.length(); ++j) {
                data[j] = vec.getDouble(j);
            }
            Arrays.sort(data);
            if (ascending) {
                for (j = 0; j < vec.length(); ++j) {
                    vec.putScalar(j, data[j]);
                }
                continue;
            }
            int count = data.length - 1;
            for (int j2 = 0; j2 < vec.length(); ++j2) {
                vec.putScalar(j2, data[count--]);
            }
        }
        return ndarray;
    }

    public static INDArray repeat(INDArray n, int num) {
        int[] nArray;
        ArrayList<INDArray> list = new ArrayList<INDArray>();
        for (int i = 0; i < num; ++i) {
            list.add(n.dup());
        }
        if (n.isColumnVector()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = n.shape()[0];
        } else {
            nArray = n.shape();
        }
        int[] shape = nArray;
        int[] retShape = Ints.concat((int[][])new int[][]{{num}, shape});
        return Nd4j.create(list, retShape);
    }

    public static INDArray linspace(int lower, int upper, int num) {
        return INSTANCE.linspace(lower, upper, num);
    }

    public static INDArray toFlattened(Collection<INDArray> matrices) {
        return INSTANCE.toFlattened(matrices);
    }

    public static IComplexNDArray complexFlatten(List<IComplexNDArray> flatten) {
        return INSTANCE.complexFlatten(flatten);
    }

    public static IComplexNDArray complexFlatten(IComplexNDArray ... flatten) {
        return INSTANCE.complexFlatten(flatten);
    }

    public static INDArray toFlattened(int length, Iterator<? extends INDArray> ... matrices) {
        return INSTANCE.toFlattened(length, matrices);
    }

    public static INDArray bilinearProducts(INDArray curr, INDArray in) {
        return INSTANCE.bilinearProducts(curr, in);
    }

    public static INDArray toFlattened(INDArray ... matrices) {
        return INSTANCE.toFlattened(matrices);
    }

    public static INDArray eye(int n) {
        return INSTANCE.eye(n);
    }

    public static void rot90(INDArray toRotate) {
        INSTANCE.rot90(toRotate);
    }

    public static void writeTxt(INDArray write, String filePath, String split) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));
        for (int i = 0; i < write.rows(); ++i) {
            StringBuffer sb = new StringBuffer();
            INDArray row = write.getRow(i);
            for (int j = 0; j < row.columns(); ++j) {
                sb.append(row.getDouble(j));
                sb.append(split);
            }
            sb.append("\n");
            writer.write(sb.toString());
        }
        writer.flush();
        writer.close();
    }

    public static INDArray readTxt(InputStream filePath, String split) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(filePath));
        ArrayList<float[]> data2 = new ArrayList<float[]>();
        int numColumns = -1;
        while ((line = reader.readLine()) != null) {
            String[] data = line.trim().split(split);
            if (numColumns < 0) {
                numColumns = data.length;
            } else assert (data.length == numColumns) : "Data has inconsistent number of columns";
            data2.add(Nd4j.read(data));
        }
        INDArray ret = Nd4j.create(data2.size(), numColumns);
        for (int i = 0; i < data2.size(); ++i) {
            ret.putRow(i, Nd4j.create(Nd4j.createBuffer((float[])data2.get(i))));
        }
        return ret;
    }

    private static float[] read(String[] split) {
        float[] ret = new float[split.length];
        for (int i = 0; i < split.length; ++i) {
            ret[i] = Float.parseFloat(split[i]);
        }
        return ret;
    }

    public static INDArray readTxt(String filePath, String split) throws IOException {
        return Nd4j.readTxt(new FileInputStream(filePath), split);
    }

    public static INDArray readTxt(String filePath) throws IOException {
        return Nd4j.readTxt(filePath, "\t");
    }

    private static INDArray loadRow(String[] data) {
        INDArray ret = Nd4j.create(data.length);
        for (int i = 0; i < data.length; ++i) {
            ret.putScalar(i, Double.parseDouble(data[i]));
        }
        return ret;
    }

    public static INDArray read(DataInputStream dis) throws IOException {
        int i;
        int dimensions = dis.readInt();
        int[] shape = new int[dimensions];
        int[] stride = new int[dimensions];
        for (i = 0; i < dimensions; ++i) {
            shape[i] = dis.readInt();
        }
        for (i = 0; i < dimensions; ++i) {
            stride[i] = dis.readInt();
        }
        String dataType = dis.readUTF();
        String type = dis.readUTF();
        if (!type.equals("real")) {
            throw new IllegalArgumentException("Trying to read in a complex ndarray");
        }
        if (dataType.equals("double")) {
            double[] data = ArrayUtil.readDouble(ArrayUtil.prod(shape), dis);
            return Nd4j.create(data, shape, stride, 0);
        }
        double[] data = ArrayUtil.readDouble(ArrayUtil.prod(shape), dis);
        return Nd4j.create(data, shape, stride, 0);
    }

    public static void write(INDArray arr, DataOutputStream dataOutputStream) throws IOException {
        int i;
        dataOutputStream.writeInt(arr.shape().length);
        for (i = 0; i < arr.shape().length; ++i) {
            dataOutputStream.writeInt(arr.size(i));
        }
        for (i = 0; i < arr.stride().length; ++i) {
            dataOutputStream.writeInt(arr.stride()[i]);
        }
        dataOutputStream.writeUTF(Nd4j.dataType() == 1 ? "float" : "double");
        dataOutputStream.writeUTF("real");
        if (Nd4j.dataType() == 0) {
            ArrayUtil.write(arr.data().asFloat(), dataOutputStream);
        } else {
            ArrayUtil.write(arr.data().asDouble(), dataOutputStream);
        }
    }

    public static void clearNans(INDArray arr) {
        BooleanIndexing.applyWhere(arr, Conditions.isNan(), new Value(EPS_THRESHOLD));
    }

    public static INDArray create(double[][] data) {
        return INSTANCE.create(data);
    }

    public static IComplexNDArray readComplex(DataInputStream dis) throws IOException {
        int i;
        int dimensions = dis.readInt();
        int[] shape = new int[dimensions];
        int[] stride = new int[dimensions];
        for (i = 0; i < dimensions; ++i) {
            shape[i] = dis.readInt();
        }
        for (i = 0; i < dimensions; ++i) {
            stride[i] = dis.readInt();
        }
        String dataType = dis.readUTF();
        String type = dis.readUTF();
        if (!type.equals("complex")) {
            throw new IllegalArgumentException("Trying to read in a real ndarray");
        }
        if (dataType.equals("double")) {
            double[] data = ArrayUtil.readDouble(ArrayUtil.prod(shape), dis);
            return Nd4j.createComplex(data, shape, stride, 0);
        }
        double[] data = ArrayUtil.read(ArrayUtil.prod(shape), dis);
        return Nd4j.createComplex(data, shape, stride, 0);
    }

    public static void writeComplex(IComplexNDArray arr, DataOutputStream dataOutputStream) throws IOException {
        int i;
        dataOutputStream.writeInt(arr.shape().length);
        for (i = 0; i < arr.shape().length; ++i) {
            dataOutputStream.writeInt(arr.size(i));
        }
        for (i = 0; i < arr.stride().length; ++i) {
            dataOutputStream.writeInt(arr.stride()[i]);
        }
        dataOutputStream.writeUTF(Nd4j.dataType() == 1 ? "float" : "double");
        dataOutputStream.writeUTF("complex");
        if (Nd4j.dataType() == 0) {
            ArrayUtil.write(arr.data().asDouble(), dataOutputStream);
        } else {
            ArrayUtil.write(arr.data().asFloat(), dataOutputStream);
        }
    }

    public static INDArray rot(INDArray reverse) {
        return INSTANCE.rot(reverse);
    }

    public static INDArray reverse(INDArray reverse) {
        return INSTANCE.reverse(reverse);
    }

    public static INDArray arange(double begin, double end) {
        return INSTANCE.arange(begin, end);
    }

    public static IComplexNumber createComplexNumber(Number real, Number imag) {
        if (Nd4j.dataType() == 1) {
            return INSTANCE.createFloat(real.floatValue(), imag.floatValue());
        }
        return INSTANCE.createDouble(real.doubleValue(), imag.doubleValue());
    }

    public static IComplexFloat createFloat(float real, float imag) {
        return INSTANCE.createFloat(real, imag);
    }

    public static IComplexDouble createDouble(double real, double imag) {
        return INSTANCE.createDouble(real, imag);
    }

    public static void copy(INDArray a, INDArray b) {
        INSTANCE.copy(a, b);
    }

    public static INDArray rand(int[] shape, double min, double max, RandomGenerator rng) {
        return INSTANCE.rand(shape, min, max, rng);
    }

    public static INDArray rand(int rows, int columns, double min, double max, RandomGenerator rng) {
        return INSTANCE.rand(rows, columns, min, max, rng);
    }

    public static IComplexNDArray diag(IComplexNDArray x, int k) {
        if (x.isScalar()) {
            return x.dup();
        }
        if (x.isVector()) {
            IComplexNDArray m = Nd4j.createComplex(x.length(), x.length());
            IComplexNDArray xLinear = x.linearView();
            for (int i = 0; i < x.length(); ++i) {
                m.putScalar(i, i, xLinear.getComplex(i));
            }
            return m;
        }
        if (x.isMatrix()) {
            int vectorLength = x.rows() - k;
            IComplexNDArray ret = Nd4j.createComplex(new int[]{vectorLength, 1});
            for (int i = 0; i < vectorLength; ++i) {
                ret.putScalar(i, x.getComplex(i, i));
            }
            return ret;
        }
        throw new IllegalArgumentException("Illegal input for diagonal of shape " + x.shape().length);
    }

    public static INDArray diag(INDArray x, int k) {
        if (x.isScalar()) {
            return x.dup();
        }
        if (x.isVector()) {
            INDArray m = Nd4j.create(x.length(), x.length());
            INDArray xLinear = x.linearView();
            for (int i = 0; i < x.length(); ++i) {
                m.put(i, i, xLinear.getDouble(i));
            }
            return m;
        }
        if (x.isMatrix()) {
            int vectorLength = x.rows() - k;
            INDArray ret = Nd4j.create(new int[]{vectorLength, 1});
            for (int i = 0; i < vectorLength; ++i) {
                ret.putScalar(i, x.getDouble(i, i));
            }
            return ret;
        }
        throw new IllegalArgumentException("Illegal input for diagonal of shape " + x.shape().length);
    }

    public static IComplexNDArray diag(IComplexNDArray x) {
        return Nd4j.diag(x, 0);
    }

    public static INDArray diag(INDArray x) {
        return Nd4j.diag(x, 0);
    }

    public static INDArray appendBias(INDArray ... vectors) {
        return INSTANCE.appendBias(vectors);
    }

    public static void doAlongDiagonal(INDArray x, Function<Number, Number> func) {
        if (x.isMatrix()) {
            for (int i = 0; i < x.rows(); ++i) {
                x.put(i, i, (Number)func.apply((Object)x.getDouble(i, i)));
            }
        }
    }

    public static void doAlongDiagonal(IComplexNDArray x, Function<IComplexNumber, IComplexNumber> func) {
        if (x.isMatrix()) {
            for (int i = 0; i < x.rows(); ++i) {
                x.putScalar(i, i, (IComplexNumber)func.apply((Object)x.getComplex(i, i)));
            }
        }
    }

    public static IComplexNDArray createComplex(INDArray arr) {
        if (arr instanceof IComplexNDArray) {
            return (IComplexNDArray)arr;
        }
        return INSTANCE.createComplex(arr);
    }

    public static IComplexNDArray createComplex(IComplexNumber[] data, int[] shape) {
        return INSTANCE.createComplex(data, shape);
    }

    public static IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int offset, char ordering) {
        return INSTANCE.createComplex(data, shape, offset, ordering);
    }

    public static IComplexNDArray createComplex(List<IComplexNDArray> arrs, int[] shape) {
        return INSTANCE.createComplex(arrs, shape);
    }

    public static INDArray rand(int rows, int columns, RandomGenerator r) {
        return INSTANCE.rand(rows, columns, r);
    }

    public static INDArray rand(int rows, int columns, long seed) {
        return INSTANCE.rand(rows, columns, seed);
    }

    public static INDArray rand(int rows, int columns) {
        return INSTANCE.rand(rows, columns);
    }

    public static INDArray randn(int rows, int columns, RandomGenerator r) {
        return INSTANCE.randn(rows, columns, r);
    }

    public static INDArray randn(int rows, int columns) {
        return INSTANCE.randn(rows, columns);
    }

    public static INDArray randn(int rows, int columns, long seed) {
        return INSTANCE.randn(rows, columns, seed);
    }

    public static INDArray rand(int[] shape, RealDistribution r) {
        return INSTANCE.rand(shape, r);
    }

    public static INDArray rand(int[] shape, RandomGenerator r) {
        return INSTANCE.rand(shape, r);
    }

    public static INDArray rand(int[] shape, long seed) {
        return INSTANCE.rand(shape, seed);
    }

    public static INDArray rand(int[] shape) {
        return INSTANCE.rand(shape);
    }

    public static INDArray randn(int[] shape, RandomGenerator r) {
        return INSTANCE.randn(shape, r);
    }

    public static INDArray randn(int[] shape) {
        return INSTANCE.randn(shape);
    }

    public static INDArray randn(int[] shape, long seed) {
        return Nd4j.randn(shape, (RandomGenerator)new MersenneTwister(seed));
    }

    public static INDArray create(float[] data, char order) {
        return INSTANCE.create(data);
    }

    public static INDArray create(double[] data, char order) {
        return INSTANCE.create(data);
    }

    public static IComplexNDArray createComplex(double[] data, char order) {
        return INSTANCE.createComplex(data);
    }

    public static INDArray create(int columns, char order) {
        return INSTANCE.create(columns);
    }

    public static IComplexNDArray createComplex(int columns, char order) {
        return INSTANCE.createComplex(columns);
    }

    public static INDArray create(float[] data) {
        return Nd4j.create(data, Nd4j.order().charValue());
    }

    public static INDArray create(double[] data) {
        return Nd4j.create(data, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(float[] data) {
        return Nd4j.createComplex(data, Nd4j.order());
    }

    private static IComplexNDArray createComplex(float[] data, Character order) {
        return INSTANCE.createComplex(data, order);
    }

    public static INDArray create(int columns) {
        return Nd4j.create(columns, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int columns) {
        return Nd4j.createComplex(columns, Nd4j.order().charValue());
    }

    public static boolean hasInvalidNumber(INDArray num) {
        INDArray linear = num.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            if (!Double.isInfinite(linear.getDouble(i)) && !Double.isNaN(linear.getDouble(i))) continue;
            return true;
        }
        return false;
    }

    public static INDArray zeros(int rows, int columns) {
        return INSTANCE.zeros(rows, columns);
    }

    public static INDArray complexZeros(int rows, int columns) {
        return INSTANCE.complexZeros(rows, columns);
    }

    public static INDArray zeros(int columns) {
        return INSTANCE.zeros(columns);
    }

    public static INDArray complexZeros(int columns) {
        return INSTANCE.complexZeros(columns);
    }

    public static IComplexNDArray complexValueOf(int num, IComplexNumber value) {
        return INSTANCE.complexValueOf(num, value);
    }

    public static IComplexNDArray complexValueOf(int[] shape, IComplexNumber value) {
        return INSTANCE.complexValueOf(shape, value);
    }

    public static IComplexNDArray complexValueOf(int num, double value) {
        return INSTANCE.complexValueOf(num, value);
    }

    public static IComplexNDArray complexValueOf(int[] shape, double value) {
        return INSTANCE.complexValueOf(shape, value);
    }

    public static INDArray valueArrayOf(int[] shape, double value) {
        return INSTANCE.valueArrayOf(shape, value);
    }

    public static INDArray valueArrayOf(int num, double value) {
        return INSTANCE.valueArrayOf(new int[]{1, num}, value);
    }

    public static INDArray valueArrayOf(int rows, int columns, double value) {
        return INSTANCE.valueArrayOf(rows, columns, value);
    }

    public static INDArray ones(int rows, int columns) {
        return INSTANCE.ones(rows, columns);
    }

    public static INDArray complexOnes(int rows, int columns) {
        return INSTANCE.complexOnes(rows, columns);
    }

    public static INDArray ones(int columns) {
        return INSTANCE.ones(columns);
    }

    public static IComplexNDArray complexOnes(int columns) {
        return INSTANCE.complexOnes(columns);
    }

    public static INDArray hstack(INDArray ... arrs) {
        return INSTANCE.hstack(arrs);
    }

    public static INDArray vstack(INDArray ... arrs) {
        return INSTANCE.vstack(arrs);
    }

    public static INDArray concat(int dimension, INDArray ... toConcat) {
        return INSTANCE.concat(dimension, toConcat);
    }

    public static IComplexNDArray concat(int dimension, IComplexNDArray ... toConcat) {
        return INSTANCE.concat(dimension, toConcat);
    }

    public static INDArray zeros(int[] shape) {
        return INSTANCE.zeros(shape);
    }

    public static IComplexNDArray complexZeros(int[] shape) {
        return INSTANCE.complexZeros(shape);
    }

    public static INDArray ones(int[] shape) {
        return INSTANCE.ones(shape);
    }

    public static IComplexNDArray complexOnes(int[] shape) {
        return INSTANCE.complexOnes(shape);
    }

    public static IComplexNDArray createComplex(float[] data, int rows, int columns, int[] stride, int offset) {
        return INSTANCE.createComplex(data, rows, columns, stride, offset);
    }

    public static INDArray create(float[] data, int rows, int columns, int[] stride, int offset) {
        return INSTANCE.create(data, rows, columns, stride, offset);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, int offset) {
        return INSTANCE.createComplex(data, shape, stride, offset);
    }

    public static INDArray create(double[] data, int[] shape, int[] stride, int offset) {
        return INSTANCE.create(data, shape, stride, offset);
    }

    public static INDArray create(double[] data, int[] shape) {
        return INSTANCE.create(data, shape);
    }

    public static INDArray create(float[] data, int[] shape) {
        return INSTANCE.create(data, shape);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape) {
        return INSTANCE.createComplex(data, shape);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape) {
        return INSTANCE.createComplex(data, shape);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride) {
        return INSTANCE.createComplex(data, shape, stride);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride) {
        return INSTANCE.createComplex(data, shape, stride);
    }

    public static IComplexNDArray createComplex(double[] data, int rows, int columns, int[] stride, int offset) {
        return INSTANCE.createComplex(data, rows, columns, stride, offset);
    }

    public static INDArray create(double[] data, int rows, int columns, int[] stride, int offset) {
        return INSTANCE.create(data, rows, columns, stride, offset);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset) {
        return INSTANCE.createComplex(data, shape, stride, offset);
    }

    public static INDArray create(float[] data, int[] shape, int offset) {
        return INSTANCE.create(data, shape, offset, Nd4j.order());
    }

    public static INDArray create(double[] data, int[] shape, int offset, char ordering) {
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape), offset);
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, int offset) {
        return INSTANCE.create(data, shape, stride, offset);
    }

    public static INDArray create(List<INDArray> list, int[] shape) {
        return INSTANCE.create(list, shape);
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride, int offset) {
        return INSTANCE.createComplex(rows, columns, stride, offset);
    }

    public static INDArray create(int rows, int columns, int[] stride, int offset) {
        return INSTANCE.create(rows, columns, stride, offset);
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride, int offset) {
        return INSTANCE.createComplex(shape, stride, offset);
    }

    public static INDArray create(int[] shape, int[] stride, int offset) {
        return INSTANCE.create(shape, stride, offset);
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride) {
        return Nd4j.createComplex(rows, columns, stride, Nd4j.order().charValue());
    }

    public static INDArray create(int rows, int columns, int[] stride) {
        return Nd4j.create(rows, columns, stride, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride) {
        return Nd4j.createComplex(shape, stride, Nd4j.order().charValue());
    }

    public static INDArray create(int[] shape, int[] stride) {
        return Nd4j.create(shape, stride, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int rows, int columns) {
        return Nd4j.createComplex(rows, columns, Nd4j.order().charValue());
    }

    public static INDArray create(int rows, int columns) {
        return Nd4j.create(rows, columns, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int ... shape) {
        return Nd4j.createComplex(shape, Nd4j.order().charValue());
    }

    public static INDArray create(int ... shape) {
        return Nd4j.create(shape, Nd4j.order().charValue());
    }

    public static INDArray scalar(Number value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static IComplexNDArray complexScalar(Number value, int offset) {
        return INSTANCE.complexScalar(value, offset);
    }

    public static IComplexNDArray complexScalar(Number value) {
        return INSTANCE.complexScalar(value);
    }

    public static INDArray scalar(double value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static INDArray scalar(float value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static INDArray scalar(Number value) {
        return INSTANCE.scalar(value);
    }

    public static INDArray scalar(double value) {
        return INSTANCE.scalar(value);
    }

    public static INDArray scalar(float value) {
        return INSTANCE.scalar(value);
    }

    public static IComplexNDArray scalar(IComplexNumber value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static IComplexNDArray scalar(IComplexFloat value) {
        return INSTANCE.scalar(value);
    }

    public static IComplexNDArray scalar(IComplexDouble value) {
        return INSTANCE.scalar(value);
    }

    public static IComplexNDArray scalar(IComplexNumber value) {
        return INSTANCE.scalar(value);
    }

    public static IComplexNDArray scalar(IComplexFloat value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static IComplexNDArray scalar(IComplexDouble value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static int[] getStrides(int[] shape, char order) {
        if (Shape.isRowVectorShape(shape) && shape.length > 1) {
            shape = new int[]{shape[1]};
        }
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran(shape);
        }
        return ArrayUtil.calcStrides(shape);
    }

    public static int[] getStrides(int[] shape) {
        return Nd4j.getStrides(shape, Nd4j.order().charValue());
    }

    public static INDArray tile(INDArray tile, int[] repeat) {
        return tile.repmat(repeat);
    }

    public static int[] getComplexStrides(int[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran(shape, 2);
        }
        return ArrayUtil.calcStrides(shape, 2);
    }

    public static int[] getComplexStrides(int[] shape) {
        return Nd4j.getComplexStrides(shape, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(float[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        return INSTANCE.createComplex(data, rows, columns, stride, offset);
    }

    public static INDArray create(float[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        return INSTANCE.create(data, rows, columns, stride, offset, ordering);
    }

    public static INDArray create(int[] shape, int dataType) {
        return INSTANCE.create(shape, dataType);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        return INSTANCE.createComplex(data, shape, stride, offset, ordering);
    }

    public static INDArray create(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        return INSTANCE.create(data, shape, stride, offset, ordering);
    }

    public static INDArray create(double[] data, int[] shape, char ordering) {
        return INSTANCE.create(data, shape, ordering);
    }

    public static INDArray create(float[] data, int[] shape, char ordering) {
        return INSTANCE.create(data, shape, (int)ordering);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, char ordering) {
        return INSTANCE.createComplex(data, shape, (int)ordering);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, char ordering) {
        return INSTANCE.createComplex(data, shape, (int)ordering);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, char ordering) {
        return INSTANCE.createComplex(data, shape, stride, (int)ordering);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, char ordering) {
        return INSTANCE.createComplex(data, shape, stride, (int)ordering);
    }

    public static IComplexNDArray createComplex(double[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        return INSTANCE.createComplex(data, rows, columns, stride, offset);
    }

    public static INDArray create(double[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        return INSTANCE.create(data, rows, columns, stride, offset);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        return INSTANCE.createComplex(data, shape, stride, offset);
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        return INSTANCE.create(data, shape, stride, offset, ordering);
    }

    public static INDArray create(List<INDArray> list, int[] shape, char ordering) {
        return INSTANCE.create(list, shape, ordering);
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride, int offset, char ordering) {
        return INSTANCE.createComplex(rows, columns, stride, offset);
    }

    public static INDArray create(int rows, int columns, int[] stride, int offset, char ordering) {
        return INSTANCE.create(rows, columns, stride, offset);
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride, int offset, char ordering) {
        return INSTANCE.createComplex(shape, stride, offset);
    }

    public static INDArray create(int[] shape, int[] stride, int offset, char ordering) {
        return INSTANCE.create(shape, stride, offset);
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride, char ordering) {
        return INSTANCE.createComplex(rows, columns, stride);
    }

    public static INDArray create(int rows, int columns, int[] stride, char ordering) {
        return INSTANCE.create(rows, columns, stride);
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride, char ordering) {
        return Nd4j.createComplex(shape, stride, 0);
    }

    public static INDArray create(int[] shape, int[] stride, char ordering) {
        return INSTANCE.create(shape, stride);
    }

    public static IComplexNDArray createComplex(int rows, int columns, char ordering) {
        return INSTANCE.createComplex(rows, columns);
    }

    public static INDArray create(int rows, int columns, char ordering) {
        return INSTANCE.create(rows, columns, ordering);
    }

    public static IComplexNDArray createComplex(int[] shape, char ordering) {
        return INSTANCE.createComplex(Nd4j.createBuffer(ArrayUtil.prod(shape) * 2), shape, 0, ordering);
    }

    public static INDArray create(int[] shape, char ordering) {
        return INSTANCE.create(shape, ordering);
    }

    public static IComplexNDArray createComplex(float[] data, int[] ints, int offset, char ordering) {
        return INSTANCE.createComplex(data, ints, ArrayUtil.calcStrides(ints, 2), offset, ordering);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int offset) {
        return Nd4j.createComplex(data, shape, offset, Nd4j.order().charValue());
    }

    public static INDArray create(double[] data, int[] shape, int offset) {
        return INSTANCE.create(data, shape, offset);
    }

    public static IComplexNDArray createComplex(double[] data, int[] ints, int offset, char ordering) {
        return INSTANCE.createComplex(data, ints, offset, ordering);
    }

    public static IComplexNDArray createComplex(double[] dim) {
        return INSTANCE.createComplex(dim, new int[]{1, dim.length / 2});
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int offset) {
        return INSTANCE.createComplex(data, shape, offset);
    }

    public static INDArray create(float[][] doubles) {
        return INSTANCE.create(doubles);
    }

    public static IComplexNDArray complexLinSpace(int i, int i1, int i2) {
        return Nd4j.createComplex(Nd4j.linspace(i, i1, i2));
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, char ordering, int offset) {
        return INSTANCE.create(data, shape, stride, offset, ordering);
    }

    public static INDArray create(float[] data, int[] shape, char ordering, int offset) {
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public static INDArray create(DataBuffer data, int[] shape, int[] strides, int offset) {
        return INSTANCE.create(data, shape, strides, offset);
    }

    public static INDArray create(DataBuffer data, int[] shape, int offset) {
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape), offset);
    }

    public static INDArray create(DataBuffer data, int[] newShape, int[] newStride, int offset, char ordering) {
        return INSTANCE.create(data, newShape, newStride, offset, ordering);
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] newShape, int[] newStrides, int offset) {
        return INSTANCE.createComplex(data, newShape, newStrides, offset);
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] shape, int offset) {
        return INSTANCE.createComplex(data, shape, offset);
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] newDims, int[] newStrides, int offset, char ordering) {
        return INSTANCE.createComplex(data, newDims, newStrides, offset, ordering);
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] shape, int offset, char ordering) {
        return INSTANCE.createComplex(data, shape, offset, ordering);
    }

    public static INDArray create(DataBuffer data, int[] shape) {
        return INSTANCE.create(data, shape);
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] shape) {
        return INSTANCE.createComplex(data, shape);
    }

    public static INDArray create(DataBuffer buffer) {
        return INSTANCE.create(buffer);
    }

    static {
        dtype = 1;
        ORDER = (char)99;
        props = new Properties();
        EPS_THRESHOLD = 1.0E-12f;
        MAX_ELEMENTS_PER_SLICE = 3;
        MAX_SLICES_TO_PRINT = 3;
        ENFORCE_NUMERICAL_STABILITY = false;
        try {
            ClassPathResource c = new ClassPathResource(LINALG_PROPS);
            props.load(c.getInputStream());
            String otherDtype = System.getProperty(DTYPE, props.get(DTYPE).toString());
            dtype = otherDtype.equals("float") ? 1 : 0;
            ORDER = System.getProperty(ORDER_KEY, props.getProperty(ORDER_KEY, "c").toString()).charAt(0);
            fftInstanceClazz = Class.forName(System.getProperty(FFT_OPS, DefaultFFTInstance.class.getName()));
            ndArrayFactoryClazz = Class.forName(System.getProperty(NDARRAY_FACTORY_CLASS, props.get(NDARRAY_FACTORY_CLASS).toString()));
            convolutionInstanceClazz = Class.forName(System.getProperty(CONVOLUTION_OPS, DefaultConvolutionInstance.class.getName()));
            Constructor<? extends NDArrayFactory> c2 = ndArrayFactoryClazz.getConstructor(Integer.TYPE, Character.class);
            FFT_INSTANCE = fftInstanceClazz.newInstance();
            INSTANCE = c2.newInstance(dtype, Character.valueOf(ORDER));
            CONVOLUTION_INSTANCE = convolutionInstanceClazz.newInstance();
            blasWrapperClazz = Class.forName(System.getProperty(BLAS_OPS, props.get(BLAS_OPS).toString()));
            BLAS_WRAPPER_INSTANCE = blasWrapperClazz.newInstance();
            UNIT = Nd4j.createFloat(1.0f, 0.0f);
            ZERO = Nd4j.createFloat(0.0f, 0.0f);
            NEG_UNIT = Nd4j.createFloat(-1.0f, 0.0f);
            ENFORCE_NUMERICAL_STABILITY = Boolean.parseBoolean(System.getProperty(NUMERICAL_STABILITY, String.valueOf(false)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

