/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.util.Shape;

public class LinAlgExceptions {
    public static void assertSameShape(INDArray n, INDArray n2) {
        if (!Shape.shapeEquals(n.shape(), n2.shape())) {
            throw new IllegalStateException("Mis matched shapes");
        }
    }

    public static void assertRows(INDArray n, INDArray n2) {
        if (n.rows() != n2.rows()) {
            throw new IllegalStateException("Mis matched rows");
        }
    }

    public static void assertMultiplies(INDArray nd1, INDArray nd2) {
        if (nd1.columns() != nd2.rows()) {
            throw new IllegalStateException("Column of left " + nd1.columns() + " != rows of right " + nd2.rows());
        }
    }

    public static void assertColumns(INDArray n, INDArray n2) {
        if (n.columns() != n2.columns()) {
            throw new IllegalStateException("Mis matched rows");
        }
    }

    public static void assertValidNum(INDArray n) {
        INDArray linear = n.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            double d = linear.getDouble(i);
            if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
            throw new IllegalStateException("Found infinite or nan");
        }
    }
}

