/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.fft;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.fft.BaseFFTInstance;
import org.nd4j.linalg.fft.FFTSliceOp;
import org.nd4j.linalg.fft.IFFTSliceOp;
import org.nd4j.linalg.fft.VectorFFT;
import org.nd4j.linalg.fft.VectorIFFT;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.ComplexNDArrayUtil;

public class DefaultFFTInstance
extends BaseFFTInstance {
    @Override
    public IComplexNDArray fft(INDArray transform, int numElements, int dimension) {
        IComplexNDArray inputC = Nd4j.createComplex(transform);
        if (inputC.isVector()) {
            return new VectorFFT(numElements).apply(inputC);
        }
        return this.rawfft(inputC, numElements, dimension);
    }

    @Override
    public IComplexNDArray fft(IComplexNDArray inputC, int numElements, int dimension) {
        if (inputC.isVector()) {
            return new VectorFFT(numElements).apply(inputC);
        }
        return this.rawfft(inputC, numElements, dimension);
    }

    @Override
    public IComplexNDArray ifft(INDArray transform, int numElements, int dimension) {
        IComplexNDArray inputC = Nd4j.createComplex(transform);
        if (inputC.isVector()) {
            return new VectorIFFT(numElements).apply(inputC);
        }
        return this.rawifft(inputC, numElements, dimension);
    }

    @Override
    public IComplexNDArray ifft(IComplexNDArray inputC, int numElements, int dimension) {
        if (inputC.isVector()) {
            return new VectorIFFT(numElements).apply(inputC);
        }
        return this.rawifft(inputC, numElements, dimension);
    }

    @Override
    public IComplexNDArray ifft(INDArray transform, int numElements) {
        IComplexNDArray inputC = Nd4j.createComplex(transform);
        if (inputC.isVector()) {
            return new VectorIFFT(numElements).apply(inputC);
        }
        return this.rawifft(inputC, numElements, inputC.shape().length - 1);
    }

    @Override
    public IComplexNDArray ifft(IComplexNDArray inputC) {
        if (inputC.isVector()) {
            return new VectorIFFT(inputC.length()).apply(inputC);
        }
        return this.rawifft(inputC, inputC.size(inputC.shape().length - 1), inputC.shape().length - 1);
    }

    @Override
    public IComplexNDArray rawfft(IComplexNDArray transform, int n, int dimension) {
        IComplexNDArray result = transform.dup();
        if (transform.size(dimension) != n) {
            int[] shape = ArrayUtil.copy(result.shape());
            shape[dimension] = n;
            result = transform.size(dimension) > n ? ComplexNDArrayUtil.truncate(result, n, dimension) : ComplexNDArrayUtil.padWithZeros(result, shape);
        }
        if (dimension != result.shape().length - 1) {
            result = result.swapAxes(result.shape().length - 1, dimension);
        }
        result.iterateOverAllRows(new FFTSliceOp(result.size(result.shape().length - 1)));
        if (dimension != result.shape().length - 1) {
            result = result.swapAxes(result.shape().length - 1, dimension);
        }
        return result;
    }

    @Override
    public IComplexNDArray rawifft(IComplexNDArray transform, int n, int dimension) {
        IComplexNDArray result = transform.dup();
        if (transform.size(dimension) != n) {
            int[] shape = ArrayUtil.copy(result.shape());
            shape[dimension] = n;
            result = transform.size(dimension) > n ? ComplexNDArrayUtil.truncate(result, n, dimension) : ComplexNDArrayUtil.padWithZeros(result, shape);
        }
        if (dimension != result.shape().length - 1) {
            result = result.swapAxes(result.shape().length - 1, dimension);
        }
        result.iterateOverAllRows(new IFFTSliceOp(result.size(result.shape().length - 1)));
        if (dimension != result.shape().length - 1) {
            result = result.swapAxes(result.shape().length - 1, dimension);
        }
        return result;
    }
}

