/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.ops.BaseElementWiseOp;
import org.nd4j.linalg.util.ComplexUtil;

public class Pow
extends BaseElementWiseOp {
    private double power;
    private IComplexNumber powComplex;

    public Pow(Integer n) {
        this.power = n.intValue();
    }

    public Pow(Double n) {
        this.power = n;
    }

    public Pow(double power, IComplexNumber powComplex) {
        this.power = power;
        this.powComplex = powComplex;
    }

    public Pow(IComplexNumber powComplex) {
        this.powComplex = powComplex;
    }

    public Pow(double power) {
        this.power = power;
    }

    public Object apply(INDArray from, Object value, int i) {
        if (value instanceof IComplexNumber) {
            IComplexNumber n = (IComplexNumber)value;
            return ComplexUtil.pow(n, this.power);
        }
        float d = ((Float)value).floatValue();
        return Float.valueOf((float)Math.pow(d, this.power));
    }
}

