/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.fft.test;

import org.junit.Assert;
import org.junit.Test;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.fft.VectorFFT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFFTTest {
    private static Logger log = LoggerFactory.getLogger(BaseFFTTest.class);
    private double[] testVector = new double[]{55.0, 0.0, -26.37586651, -21.3098631, 12.07106781, 2.58578644, -9.44674873, 1.75576651, 5.0, -6.0, -0.89639702, 5.89790214, -2.07106781, -5.41421356, 4.71901226, 2.83227249, -5.0, -6.123234E-15, 4.71901226, -2.83227249, -2.07106781, 5.41421356, -0.89639702, -5.89790214, 5.0, 6.0, -9.44674873, -1.75576651, 12.07106781, -2.58578644, -26.37586651, 21.3098631};
    private float[] testFloatVector = new float[]{55.0f, 0.0f, -5.0f, 15.388417f, -5.0f, 6.8819094f, -5.0f, 3.6327126f, -5.0f, 1.6245985f, -5.0f, 4.440892E-16f, -5.0f, -1.6245985f, -5.0f, -3.6327126f, -5.0f, -6.8819094f, -5.0f, -15.388417f};

    @Test
    public void testColumnVector() {
        IComplexNDArray n = new VectorFFT(8).apply(Nd4j.complexLinSpace(1, 8, 8));
        IComplexNDArray assertion = Nd4j.createComplex(new double[]{36.0, 0.0, -4.0, 9.65685425, -4.0, 4.0, -4.0, 1.65685425, -4.0, 0.0, -4.0, -1.65685425, -4.0, -4.0, -4.0, -9.65685425}, new int[]{8});
        Assert.assertEquals((Object)n, (Object)assertion);
    }

    @Test
    public void testWithOffset() {
        Nd4j.factory().setOrder('f');
        INDArray n = Nd4j.create(Nd4j.linspace(1, 30, 30).data(), new int[]{3, 5, 2});
        INDArray swapped = n.swapAxes(n.shape().length - 1, 1);
        VectorFFT op = new VectorFFT(5);
        INDArray firstSlice = swapped.slice(0).slice(0);
        IComplexNDArray test = Nd4j.createComplex(firstSlice);
        IComplexNDArray testNoOffset = Nd4j.createComplex(new double[]{1.0, 0.0, 4.0, 0.0, 7.0, 0.0, 10.0, 0.0, 13.0, 0.0}, new int[]{5});
        Assert.assertEquals((Object)op.apply(testNoOffset), (Object)op.apply(test));
    }
}

