/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.fft;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.DimensionSlice;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SliceOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.fft.VectorFFT;

public class FFTSliceOp
implements SliceOp {
    private int n;

    public FFTSliceOp(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of elements per dimension must be at least 1");
        }
        this.n = n;
    }

    @Override
    public void operate(DimensionSlice nd) {
        block3: {
            block2: {
                if (!(nd.getResult() instanceof INDArray)) break block2;
                INDArray a = (INDArray)nd.getResult();
                int n = this.n < 1 ? a.length() : this.n;
                INDArray result = new VectorFFT(n).apply(Nd4j.createComplex(a)).getReal();
                for (int i = 0; i < result.length(); ++i) {
                    a.putScalar(i, (Number)Float.valueOf(result.get(i)));
                }
                break block3;
            }
            if (!(nd.getResult() instanceof IComplexNDArray)) break block3;
            IComplexNDArray a = (IComplexNDArray)nd.getResult();
            IComplexNDArray result = new VectorFFT(this.n).apply(a);
            for (int i = 0; i < result.length(); ++i) {
                a.put(i, result.getScalar(i));
            }
        }
    }

    @Override
    public void operate(INDArray nd) {
        block3: {
            block2: {
                if (!(nd instanceof INDArray)) break block2;
                INDArray a = nd;
                int n = this.n < 1 ? a.length() : this.n;
                INDArray result = new VectorFFT(n).apply(Nd4j.createComplex(a)).getReal();
                for (int i = 0; i < result.length(); ++i) {
                    a.putScalar(i, (Number)Float.valueOf(result.get(i)));
                }
                break block3;
            }
            if (!(nd instanceof IComplexNDArray)) break block3;
            IComplexNDArray a = (IComplexNDArray)nd;
            IComplexNDArray result = new VectorFFT(this.n).apply(a);
            for (int i = 0; i < result.length(); ++i) {
                a.put(i, result.getScalar(i));
            }
        }
    }
}

