/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.benchmark;

import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeOperations
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(TimeOperations.class);
    private INDArray testing;
    private int numTimesRun = 1;
    private StopWatch watch = new StopWatch();
    private INDArray other;

    public TimeOperations(INDArray n) {
        this(n, 1);
    }

    public TimeOperations(INDArray n, int numTimesRun) {
        this.testing = n;
        this.other = Nd4j.ones(n.shape());
        this.numTimesRun = numTimesRun;
    }

    public void benchMarkScalarMuli() {
        System.out.println("Scalar multiplication took " + this.runNTimes(new Runnable(){

            @Override
            public void run() {
                TimeOperations.this.testing.mul(1);
            }
        }).getMean() + " milliseconds");
    }

    public void benchMarkElementWiseMul() {
        System.out.println("Element wise  multiplication took " + this.runNTimes(new Runnable(){

            @Override
            public void run() {
                TimeOperations.this.testing.mul(TimeOperations.this.other);
            }
        }).getMean() + " milliseconds");
    }

    public void benchMarkScalarAdd() {
        System.out.println("Scalar addition took " + this.runNTimes(new Runnable(){

            @Override
            public void run() {
                TimeOperations.this.testing.add(1);
            }
        }).getMean() + " milliseconds");
    }

    public void benchMarkElementWiseAdd() {
        System.out.println("Element wise  addition took " + this.runNTimes(new Runnable(){

            @Override
            public void run() {
                TimeOperations.this.testing.add(TimeOperations.this.other);
            }
        }).getMean() + " milliseconds");
    }

    public void benchmarkCreation() {
        System.out.println("Benchmarking creation...");
        System.out.println(this.runNTimes(new Runnable(){

            @Override
            public void run() {
                Nd4j.create(new double[]{10000.0}, new int[]{2, 5000});
            }
        }).getMean() + " milliseconds");
    }

    public void benchmarkRavel() {
        System.out.println("Benchmarking ravel...");
        System.out.println(this.runNTimes(new Runnable(){

            @Override
            public void run() {
                TimeOperations.this.testing.ravel();
            }
        }).getMean() + " milliseconds");
    }

    public SummaryStatistics runNTimes(Runnable run) {
        SummaryStatistics sum = new SummaryStatistics();
        for (int i = 0; i < this.numTimesRun; ++i) {
            sum.addValue((double)this.timeOp(run));
        }
        return sum;
    }

    public long timeOp(Runnable run) {
        this.watch.start();
        run.run();
        this.watch.stop();
        long time = this.watch.getTime();
        this.watch.reset();
        return time;
    }

    @Override
    public void run() {
        this.benchmarkRavel();
        this.benchmarkCreation();
        this.benchMarkScalarAdd();
        this.benchMarkElementWiseAdd();
        this.benchMarkElementWiseMul();
        this.benchMarkScalarMuli();
    }
}

