/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops;

import java.util.concurrent.CountDownLatch;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.ops.BaseElementWiseOp;
import org.nd4j.linalg.ops.TwoArrayElementWiseOp;
import org.nd4j.linalg.util.Shape;

public abstract class BaseTwoArrayElementWiseOp
extends BaseElementWiseOp
implements TwoArrayElementWiseOp {
    protected INDArray to;
    protected INDArray other;

    @Override
    public void applyTransformToDestination(INDArray from, INDArray destination, INDArray other, int i) {
        if (this.scalarValue != null) {
            if (destination instanceof IComplexNDArray) {
                IComplexNumber number = (IComplexNumber)this.apply(destination, this.scalarValue, i);
                IComplexNDArray c2 = (IComplexNDArray)destination;
                c2.putScalar(i, number);
            } else {
                float f = ((Float)this.apply(from, this.scalarValue, i)).floatValue();
                destination.putScalar(i, (Number)Float.valueOf(f));
            }
        } else {
            if (destination instanceof IComplexNDArray) {
                IComplexNDArray c2 = (IComplexNDArray)destination;
                IComplexNumber n = (IComplexNumber)this.apply(destination, this.getOther(other, i), i);
                c2.putScalar(i, n);
            }
            float f = ((Float)this.apply(from, this.getOther(other, i), i)).floatValue();
            destination.putScalar(i, (Number)Float.valueOf(f));
        }
    }

    @Override
    public void exec() {
        block14: {
            block13: {
                if (this.from != null && this.to != null && !this.from.isScalar() && !this.to.isScalar()) assert (Shape.shapeEquals(this.from.shape(), this.to.shape())) : "From and to must be same length";
                if (this.from != null && this.other != null && !this.from.isScalar() && !this.to.isScalar()) assert (this.from.length() == this.other.length()) : "From and other must be the same length";
                if (this.to != null) break block13;
                if (this.scalarValue == null) break block14;
                for (int i = 0; i < this.from.length(); ++i) {
                    if (this.scalarValue != null) {
                        this.applyTransformToOrigin(this.from, i, this.scalarValue);
                        continue;
                    }
                    this.applyTransformToOrigin(this.from, i);
                }
                break block14;
            }
            if (this.other == null && this.scalarValue != null) {
                int num = this.from.vectorsAlongDimension(0);
                final CountDownLatch latch = new CountDownLatch(num);
                int i = 0;
                while (i < num) {
                    final int iDup = i++;
                    BaseTwoArrayElementWiseOp.getThreads().execute(new Runnable(){

                        @Override
                        public void run() {
                            final INDArray fromCurr = BaseTwoArrayElementWiseOp.this.from != null ? BaseTwoArrayElementWiseOp.this.from.vectorAlongDimension(iDup, 0) : null;
                            BaseElementWiseOp.getThreads().execute(new Runnable(){

                                @Override
                                public void run() {
                                    for (int j = 0; j < fromCurr.length(); ++j) {
                                        BaseTwoArrayElementWiseOp.this.applyTransformToOrigin(fromCurr, j, BaseTwoArrayElementWiseOp.this.scalarValue);
                                    }
                                    latch.countDown();
                                }
                            });
                        }
                    });
                }
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                assert (this.from.length() == this.to.length()) : "From and to must be same length";
                int num = this.from.vectorsAlongDimension(0);
                final CountDownLatch latch = new CountDownLatch(num);
                int i = 0;
                while (i < num) {
                    final int iDup = i++;
                    BaseTwoArrayElementWiseOp.getThreads().execute(new Runnable(){

                        @Override
                        public void run() {
                            final INDArray curr = BaseTwoArrayElementWiseOp.this.to.vectorAlongDimension(iDup, 0);
                            final INDArray currOther = BaseTwoArrayElementWiseOp.this.other != null ? BaseTwoArrayElementWiseOp.this.other.vectorAlongDimension(iDup, 0) : null;
                            final INDArray fromCurr = BaseTwoArrayElementWiseOp.this.from != null ? BaseTwoArrayElementWiseOp.this.from.vectorAlongDimension(iDup, 0) : null;
                            BaseElementWiseOp.getThreads().execute(new Runnable(){

                                @Override
                                public void run() {
                                    for (int j = 0; j < fromCurr.length(); ++j) {
                                        BaseTwoArrayElementWiseOp.this.applyTransformToDestination(fromCurr, curr, currOther, j);
                                    }
                                    latch.countDown();
                                }
                            });
                        }
                    });
                }
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public Object getOther(INDArray other, int i) {
        if (other instanceof IComplexNDArray) {
            IComplexNDArray c = (IComplexNDArray)other;
            return c.getComplex(i);
        }
        return Float.valueOf(other.get(i));
    }

    protected Object doOp(INDArray originNDArray, int i, Object value) {
        Object origin = this.getFromOrigin(originNDArray, i);
        if (value instanceof IComplexNumber) {
            IComplexNDArray complexValue = (IComplexNDArray)value;
            IComplexNumber otherValue = (IComplexNumber)complexValue.element();
            if (origin instanceof IComplexNDArray) {
                IComplexNDArray originComplex = (IComplexNDArray)origin;
                IComplexNumber originValue = (IComplexNumber)originComplex.element();
                return this.complexComplex(originValue, otherValue);
            }
            float element = ((Float)origin).floatValue();
            return this.realComplex(element, otherValue);
        }
        if (origin instanceof IComplexNumber) {
            IComplexNumber firstValue = (IComplexNumber)origin;
            float realValue = ((Float)value).floatValue();
            return this.complexReal(firstValue, realValue);
        }
        float firstElement = ((Float)origin).floatValue();
        float secondElement = ((Float)value).floatValue();
        return Float.valueOf(this.realReal(firstElement, secondElement));
    }

    protected abstract IComplexNumber complexComplex(IComplexNumber var1, IComplexNumber var2);

    protected abstract IComplexNumber realComplex(float var1, IComplexNumber var2);

    protected abstract IComplexNumber complexReal(IComplexNumber var1, float var2);

    protected abstract float realReal(float var1, float var2);

    public Object apply(INDArray origin, Object value, int i) {
        return this.doOp(origin, i, value);
    }

    @Override
    public INDArray to() {
        return this.to;
    }
}

