/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.ops.ElementWiseOp;

public abstract class BaseElementWiseOp
implements ElementWiseOp {
    protected INDArray from;
    protected Object scalarValue;
    protected static ExecutorService dimensionThreads = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);

    public static synchronized ExecutorService getThreads() {
        return dimensionThreads;
    }

    @Override
    public void applyTransformToOrigin(INDArray origin, int i) {
        if (origin instanceof IComplexNumber) {
            IComplexNDArray c2 = (IComplexNDArray)origin;
            IComplexNumber transformed = (IComplexNumber)this.apply(origin, this.getFromOrigin(origin, i), i);
            c2.putScalar(i, transformed);
        } else {
            float f = ((Float)this.apply(origin, this.getFromOrigin(origin, i), i)).floatValue();
            origin.putScalar(i, (Number)Float.valueOf(f));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applyTransformToOrigin(INDArray origin, int i, Object valueToApply) {
        if (valueToApply instanceof IComplexNumber) {
            if (!(origin instanceof IComplexNDArray)) throw new IllegalArgumentException("Unable to apply a non complex number to a real ndarray");
            IComplexNDArray c2 = (IComplexNDArray)origin;
            IComplexNumber apply = (IComplexNumber)this.apply(origin, valueToApply, i);
            c2.putScalar(i, apply);
            return;
        } else {
            float f = ((Float)this.apply(origin, Float.valueOf(((Float)valueToApply).floatValue()), i)).floatValue();
            origin.putScalar(i, (Number)Float.valueOf(f));
        }
    }

    public Object getFromOrigin(INDArray origin, int i) {
        if (origin instanceof IComplexNDArray) {
            IComplexNDArray c2 = (IComplexNDArray)origin;
            return c2.getComplex(i);
        }
        return Float.valueOf(origin.get(i));
    }

    @Override
    public INDArray from() {
        return this.from;
    }

    @Override
    public void exec() {
        INDArray linear = this.from.linearView();
        if (linear instanceof IComplexNDArray) {
            IComplexNDArray cLinear = (IComplexNDArray)linear;
            for (int i = 0; i < cLinear.length(); ++i) {
                IComplexNumber result = (IComplexNumber)this.apply(cLinear, cLinear.getComplex(i), i);
                cLinear.putScalar(i, result);
            }
        } else {
            for (int i = 0; i < linear.length(); ++i) {
                float apply = ((Float)this.apply(linear, Float.valueOf(linear.get(i)), i)).floatValue();
                this.from.putScalar(i, (Number)Float.valueOf(apply));
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (!BaseElementWiseOp.getThreads().isShutdown()) {
                    BaseElementWiseOp.getThreads().shutdown();
                }
            }
        }));
    }
}

