/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import com.google.common.primitives.Ints;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.BlasWrapper;
import org.nd4j.linalg.factory.NDArrayFactory;
import org.nd4j.linalg.util.ArrayUtil;
import org.springframework.core.io.ClassPathResource;

public class Nd4j {
    private static Class<? extends BlasWrapper> blasWrapperClazz;
    private static Class<? extends NDArrayFactory> ndArrayFactoryClazz;
    private static BlasWrapper BLAS_WRAPPER_INSTANCE;
    public static final String LINALG_PROPS = "/nd4j.properties";
    public static final String REAL_CLASS_PROP = "real.class";
    public static final String COMPLEX_CLASS_PROP = "complex.class";
    public static final String DTYPE = "dtype";
    public static final String BLAS_OPS = "blas.ops";
    public static String dtype;
    public static char ORDER;
    public static final String ORDER_KEY = "ndarray.order";
    public static final String NDARRAY_FACTORY_CLASS = "ndarrayfactory.class";
    private static NDArrayFactory INSTANCE;
    private static Properties props;
    public static final IComplexNumber UNIT;
    public static final IComplexNumber ZERO;
    public static final IComplexNumber NEG_UNIT;

    public static NDArrayFactory factory() {
        return INSTANCE;
    }

    public static void setFactory(NDArrayFactory factory) {
        INSTANCE = factory;
    }

    public static void setBlasWrapper(BlasWrapper factory) {
        BLAS_WRAPPER_INSTANCE = factory;
    }

    public static Character order() {
        return Character.valueOf(Nd4j.factory().order());
    }

    public static String dataType() {
        return dtype;
    }

    public static BlasWrapper getBlasWrapper() {
        return BLAS_WRAPPER_INSTANCE;
    }

    public static IComplexNDArray repeat(IComplexNDArray n, int num) {
        ArrayList<IComplexNDArray> list = new ArrayList<IComplexNDArray>();
        for (int i = 0; i < num; ++i) {
            list.add(n);
        }
        return Nd4j.createComplex(list, Ints.concat((int[][])new int[][]{{num}, n.shape()}));
    }

    public static INDArray repeat(INDArray n, int num) {
        ArrayList<INDArray> list = new ArrayList<INDArray>();
        for (int i = 0; i < num; ++i) {
            list.add(n);
        }
        return Nd4j.create(list, Ints.concat((int[][])new int[][]{{num}, n.shape()}));
    }

    public static INDArray linspace(int lower, int upper, int num) {
        return INSTANCE.linspace(lower, upper, num);
    }

    public static INDArray toFlattened(Collection<INDArray> matrices) {
        return INSTANCE.toFlattened(matrices);
    }

    public static IComplexNDArray complexFlatten(List<IComplexNDArray> flatten) {
        return INSTANCE.complexFlatten(flatten);
    }

    public static IComplexNDArray complexFlatten(IComplexNDArray ... flatten) {
        return INSTANCE.complexFlatten(flatten);
    }

    public static INDArray toFlattened(int length, Iterator<? extends INDArray> ... matrices) {
        return INSTANCE.toFlattened(length, matrices);
    }

    public static INDArray bilinearProducts(INDArray curr, INDArray in) {
        return INSTANCE.bilinearProducts(curr, in);
    }

    public static INDArray toFlattened(INDArray ... matrices) {
        return INSTANCE.toFlattened(matrices);
    }

    public static INDArray eye(int n) {
        return INSTANCE.eye(n);
    }

    public static void rot90(INDArray toRotate) {
        INSTANCE.rot90(toRotate);
    }

    public static INDArray read(DataInputStream dis) throws IOException {
        int i;
        int dimensions = dis.readInt();
        int[] shape = new int[dimensions];
        int[] stride = new int[dimensions];
        for (i = 0; i < dimensions; ++i) {
            shape[i] = dis.readInt();
        }
        for (i = 0; i < dimensions; ++i) {
            stride[i] = dis.readInt();
        }
        String dataType = dis.readUTF();
        String type = dis.readUTF();
        if (!type.equals("real")) {
            throw new IllegalArgumentException("Trying to read in a complex ndarray");
        }
        if (dataType.equals("float")) {
            float[] data = ArrayUtil.readFloat(ArrayUtil.prod(shape), dis);
            return Nd4j.create(data, shape, stride, 0);
        }
        float[] data = ArrayUtil.readFloat(ArrayUtil.prod(shape), dis);
        return Nd4j.create(data, shape, stride, 0);
    }

    public static void write(INDArray arr, DataOutputStream dataOutputStream) throws IOException {
        int i;
        dataOutputStream.writeInt(arr.shape().length);
        for (i = 0; i < arr.shape().length; ++i) {
            dataOutputStream.writeInt(arr.size(i));
        }
        for (i = 0; i < arr.stride().length; ++i) {
            dataOutputStream.writeInt(arr.stride()[i]);
        }
        dataOutputStream.writeUTF(Nd4j.dataType());
        dataOutputStream.writeUTF("real");
        if (Nd4j.dataType().equals("float")) {
            ArrayUtil.write(arr.floatData(), dataOutputStream);
        } else {
            ArrayUtil.write(arr.data(), dataOutputStream);
        }
    }

    public static INDArray create(double[][] data) {
        return INSTANCE.create(data);
    }

    public static IComplexNDArray readComplex(DataInputStream dis) throws IOException {
        int i;
        int dimensions = dis.readInt();
        int[] shape = new int[dimensions];
        int[] stride = new int[dimensions];
        for (i = 0; i < dimensions; ++i) {
            shape[i] = dis.readInt();
        }
        for (i = 0; i < dimensions; ++i) {
            stride[i] = dis.readInt();
        }
        String dataType = dis.readUTF();
        String type = dis.readUTF();
        if (!type.equals("complex")) {
            throw new IllegalArgumentException("Trying to read in a real ndarray");
        }
        if (dataType.equals("float")) {
            float[] data = ArrayUtil.readFloat(ArrayUtil.prod(shape), dis);
            return Nd4j.createComplex(data, shape, stride, 0);
        }
        double[] data = ArrayUtil.read(ArrayUtil.prod(shape), dis);
        return Nd4j.createComplex(data, shape, stride, 0);
    }

    public static void writeComplex(IComplexNDArray arr, DataOutputStream dataOutputStream) throws IOException {
        int i;
        dataOutputStream.writeInt(arr.shape().length);
        for (i = 0; i < arr.shape().length; ++i) {
            dataOutputStream.writeInt(arr.size(i));
        }
        for (i = 0; i < arr.stride().length; ++i) {
            dataOutputStream.writeInt(arr.stride()[i]);
        }
        dataOutputStream.writeUTF(Nd4j.dataType());
        dataOutputStream.writeUTF("complex");
        if (Nd4j.dataType().equals("float")) {
            ArrayUtil.write(arr.floatData(), dataOutputStream);
        } else {
            ArrayUtil.write(arr.data(), dataOutputStream);
        }
    }

    public static INDArray rot(INDArray reverse) {
        return INSTANCE.rot(reverse);
    }

    public static INDArray reverse(INDArray reverse) {
        return INSTANCE.reverse(reverse);
    }

    public static INDArray arange(double begin, double end) {
        return INSTANCE.arange(begin, end);
    }

    public static IComplexFloat createComplexNumber(Number real, Number imag) {
        return INSTANCE.createFloat(real.floatValue(), imag.floatValue());
    }

    public static IComplexFloat createFloat(float real, float imag) {
        return INSTANCE.createFloat(real, imag);
    }

    public static IComplexDouble createDouble(double real, double imag) {
        return INSTANCE.createDouble(real, imag);
    }

    public static void copy(INDArray a, INDArray b) {
        INSTANCE.copy(a, b);
    }

    public static INDArray rand(int[] shape, float min, float max, RandomGenerator rng) {
        return INSTANCE.rand(shape, min, max, rng);
    }

    public static INDArray rand(int rows, int columns, float min, float max, RandomGenerator rng) {
        return INSTANCE.rand(rows, columns, min, max, rng);
    }

    public static INDArray appendBias(INDArray ... vectors) {
        return INSTANCE.appendBias(vectors);
    }

    public static IComplexNDArray createComplex(INDArray arr) {
        if (arr instanceof IComplexNDArray) {
            return (IComplexNDArray)arr;
        }
        return INSTANCE.createComplex(arr);
    }

    public static IComplexNDArray createComplex(IComplexNumber[] data, int[] shape) {
        return INSTANCE.createComplex(data, shape);
    }

    public static IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int offset, char ordering) {
        return INSTANCE.createComplex(data, shape, offset, ordering);
    }

    public static IComplexNDArray createComplex(List<IComplexNDArray> arrs, int[] shape) {
        return INSTANCE.createComplex(arrs, shape);
    }

    public static INDArray rand(int rows, int columns, RandomGenerator r) {
        return INSTANCE.rand(rows, columns, r);
    }

    public static INDArray rand(int rows, int columns, long seed) {
        return INSTANCE.rand(rows, columns, seed);
    }

    public static INDArray rand(int rows, int columns) {
        return INSTANCE.rand(rows, columns);
    }

    public static INDArray randn(int rows, int columns, RandomGenerator r) {
        return INSTANCE.randn(rows, columns, r);
    }

    public static INDArray randn(int rows, int columns) {
        return INSTANCE.rand(rows, columns);
    }

    public static INDArray randn(int rows, int columns, long seed) {
        return INSTANCE.randn(rows, columns, seed);
    }

    public static INDArray rand(int[] shape, RealDistribution r) {
        return INSTANCE.rand(shape, r);
    }

    public static INDArray rand(int[] shape, RandomGenerator r) {
        return INSTANCE.rand(shape, r);
    }

    public static INDArray rand(int[] shape, long seed) {
        return INSTANCE.rand(shape, seed);
    }

    public static INDArray rand(int[] shape) {
        return INSTANCE.rand(shape);
    }

    public static INDArray randn(int[] shape, RandomGenerator r) {
        return INSTANCE.randn(shape, r);
    }

    public static INDArray randn(int[] shape) {
        return INSTANCE.randn(shape);
    }

    public static INDArray randn(int[] shape, long seed) {
        return Nd4j.randn(shape, (RandomGenerator)new MersenneTwister(seed));
    }

    public static INDArray create(double[] data, char order) {
        return INSTANCE.create(data);
    }

    public static INDArray create(float[] data, char order) {
        return INSTANCE.create(data);
    }

    public static IComplexNDArray createComplex(double[] data, char order) {
        return INSTANCE.createComplex(data);
    }

    public static INDArray create(int columns, char order) {
        return INSTANCE.create(columns);
    }

    public static IComplexNDArray createComplex(int columns, char order) {
        return INSTANCE.createComplex(columns);
    }

    public static INDArray create(double[] data) {
        return Nd4j.create(data, Nd4j.order().charValue());
    }

    public static INDArray create(float[] data) {
        return Nd4j.create(data, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(double[] data) {
        return Nd4j.createComplex(data, Nd4j.order().charValue());
    }

    public static INDArray create(int columns) {
        return Nd4j.create(columns, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int columns) {
        return Nd4j.createComplex(columns, Nd4j.order().charValue());
    }

    public static boolean hasInvalidNumber(INDArray num) {
        INDArray linear = num.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            if (!Float.isInfinite(linear.get(i)) && !Float.isNaN(linear.get(i))) continue;
            return true;
        }
        return false;
    }

    public static INDArray zeros(int rows, int columns) {
        return INSTANCE.zeros(rows, columns);
    }

    public static INDArray complexZeros(int rows, int columns) {
        return INSTANCE.complexZeros(rows, columns);
    }

    public static INDArray zeros(int columns) {
        return INSTANCE.zeros(columns);
    }

    public static INDArray complexZeros(int columns) {
        return INSTANCE.complexZeros(columns);
    }

    public static IComplexNDArray complexValueOf(int num, IComplexNumber value) {
        return INSTANCE.complexValueOf(num, value);
    }

    public static IComplexNDArray complexValueOf(int[] shape, IComplexNumber value) {
        return INSTANCE.complexValueOf(shape, value);
    }

    public static IComplexNDArray complexValueOf(int num, double value) {
        return INSTANCE.complexValueOf(num, value);
    }

    public static IComplexNDArray complexValueOf(int[] shape, double value) {
        return INSTANCE.complexValueOf(shape, value);
    }

    public static INDArray valueArrayOf(int[] shape, double value) {
        return INSTANCE.valueArrayOf(shape, value);
    }

    public static INDArray valueArrayOf(int num, double value) {
        return INSTANCE.valueArrayOf(new int[]{1, num}, value);
    }

    public static INDArray valueArrayOf(int rows, int columns, double value) {
        return INSTANCE.valueArrayOf(rows, columns, value);
    }

    public static INDArray ones(int rows, int columns) {
        return INSTANCE.ones(rows, columns);
    }

    public static INDArray complexOnes(int rows, int columns) {
        return INSTANCE.complexOnes(rows, columns);
    }

    public static INDArray ones(int columns) {
        return INSTANCE.ones(columns);
    }

    public static IComplexNDArray complexOnes(int columns) {
        return INSTANCE.complexOnes(columns);
    }

    public static INDArray hstack(INDArray ... arrs) {
        return INSTANCE.hstack(arrs);
    }

    public static INDArray vstack(INDArray ... arrs) {
        return INSTANCE.vstack(arrs);
    }

    public static INDArray concat(int dimension, INDArray ... toConcat) {
        return INSTANCE.concat(dimension, toConcat);
    }

    public static IComplexNDArray concat(int dimension, IComplexNDArray ... toConcat) {
        return INSTANCE.concat(dimension, toConcat);
    }

    public static INDArray zeros(int[] shape) {
        return INSTANCE.zeros(shape);
    }

    public static IComplexNDArray complexZeros(int[] shape) {
        return INSTANCE.complexZeros(shape);
    }

    public static INDArray ones(int[] shape) {
        return INSTANCE.ones(shape);
    }

    public static IComplexNDArray complexOnes(int[] shape) {
        return INSTANCE.complexOnes(shape);
    }

    public static IComplexNDArray createComplex(float[] data, int rows, int columns, int[] stride, int offset) {
        return INSTANCE.createComplex(data, rows, columns, stride, offset);
    }

    public static INDArray create(float[] data, int rows, int columns, int[] stride, int offset) {
        return INSTANCE.create(data, rows, columns, stride, offset);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset) {
        return INSTANCE.createComplex(data, shape, stride, offset);
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, int offset) {
        return INSTANCE.create(data, shape, stride, offset);
    }

    public static INDArray create(double[] data, int[] shape) {
        return INSTANCE.create(data, shape);
    }

    public static INDArray create(float[] data, int[] shape) {
        return INSTANCE.create(data, shape);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape) {
        return INSTANCE.createComplex(data, shape);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape) {
        return INSTANCE.createComplex(data, shape);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride) {
        return INSTANCE.createComplex(data, shape, stride);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride) {
        return INSTANCE.createComplex(data, shape, stride);
    }

    public static IComplexNDArray createComplex(double[] data, int rows, int columns, int[] stride, int offset) {
        return INSTANCE.createComplex(data, rows, columns, stride, offset);
    }

    public static INDArray create(double[] data, int rows, int columns, int[] stride, int offset) {
        return INSTANCE.create(data, rows, columns, stride, offset);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, int offset) {
        return INSTANCE.createComplex(data, shape, stride, offset);
    }

    public static INDArray create(double[] data, int[] shape, int offset) {
        return Nd4j.create(data, shape, offset, Nd4j.order().charValue());
    }

    public static INDArray create(double[] data, int[] shape, int offset, char ordering) {
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape), offset);
    }

    public static INDArray create(double[] data, int[] shape, int[] stride, int offset) {
        return INSTANCE.create(data, shape, stride, offset);
    }

    public static INDArray create(List<INDArray> list, int[] shape) {
        return INSTANCE.create(list, shape);
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride, int offset) {
        return INSTANCE.createComplex(rows, columns, stride, offset);
    }

    public static INDArray create(int rows, int columns, int[] stride, int offset) {
        return INSTANCE.create(rows, columns, stride, offset);
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride, int offset) {
        return INSTANCE.createComplex(shape, stride, offset);
    }

    public static INDArray create(int[] shape, int[] stride, int offset) {
        return INSTANCE.create(shape, stride, offset);
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride) {
        return Nd4j.createComplex(rows, columns, stride, Nd4j.order().charValue());
    }

    public static INDArray create(int rows, int columns, int[] stride) {
        return Nd4j.create(rows, columns, stride, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride) {
        return Nd4j.createComplex(shape, stride, Nd4j.order().charValue());
    }

    public static INDArray create(int[] shape, int[] stride) {
        return Nd4j.create(shape, stride, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int rows, int columns) {
        return Nd4j.createComplex(rows, columns, Nd4j.order().charValue());
    }

    public static INDArray create(int rows, int columns) {
        return Nd4j.create(rows, columns, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int[] shape) {
        return Nd4j.createComplex(shape, Nd4j.order().charValue());
    }

    public static INDArray create(int[] shape) {
        return Nd4j.create(shape, Nd4j.order().charValue());
    }

    public static INDArray scalar(Number value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static IComplexNDArray complexScalar(Number value, int offset) {
        return INSTANCE.complexScalar(value, offset);
    }

    public static IComplexNDArray complexScalar(Number value) {
        return INSTANCE.complexScalar(value);
    }

    public static INDArray scalar(float value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static INDArray scalar(double value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static INDArray scalar(Number value) {
        return INSTANCE.scalar(value);
    }

    public static INDArray scalar(float value) {
        return INSTANCE.scalar(value);
    }

    public static INDArray scalar(double value) {
        return INSTANCE.scalar(value);
    }

    public static IComplexNDArray scalar(IComplexNumber value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static IComplexNDArray scalar(IComplexFloat value) {
        return INSTANCE.scalar(value);
    }

    public static IComplexNDArray scalar(IComplexDouble value) {
        return INSTANCE.scalar(value);
    }

    public static IComplexNDArray scalar(IComplexNumber value) {
        return INSTANCE.scalar(value);
    }

    public static IComplexNDArray scalar(IComplexFloat value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static IComplexNDArray scalar(IComplexDouble value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static int[] getStrides(int[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran(shape);
        }
        return ArrayUtil.calcStrides(shape);
    }

    public static int[] getStrides(int[] shape) {
        return Nd4j.getStrides(shape, Nd4j.order().charValue());
    }

    public static int[] getComplexStrides(int[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran(shape, 2);
        }
        return ArrayUtil.calcStrides(shape, 2);
    }

    public static int[] getComplexStrides(int[] shape) {
        return Nd4j.getComplexStrides(shape, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(float[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        return INSTANCE.createComplex(data, rows, columns, stride, offset);
    }

    public static INDArray create(float[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        return INSTANCE.create(data, rows, columns, stride, offset);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        return INSTANCE.createComplex(data, shape, stride, offset);
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        return INSTANCE.create(data, shape, stride, offset, ordering);
    }

    public static INDArray create(double[] data, int[] shape, char ordering) {
        return INSTANCE.create(data, shape);
    }

    public static INDArray create(float[] data, int[] shape, char ordering) {
        return INSTANCE.create(data, shape);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, char ordering) {
        return INSTANCE.createComplex(data, shape);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, char ordering) {
        return INSTANCE.createComplex(data, shape);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, char ordering) {
        return INSTANCE.createComplex(data, shape, stride);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, char ordering) {
        return INSTANCE.createComplex(data, shape, stride);
    }

    public static IComplexNDArray createComplex(double[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        return INSTANCE.createComplex(data, rows, columns, stride, offset);
    }

    public static INDArray create(double[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        return INSTANCE.create(data, rows, columns, stride, offset);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        return INSTANCE.createComplex(data, shape, stride, offset);
    }

    public static INDArray create(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        return INSTANCE.create(data, shape, stride, offset);
    }

    public static INDArray create(List<INDArray> list, int[] shape, char ordering) {
        return INSTANCE.create(list, shape);
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride, int offset, char ordering) {
        return INSTANCE.createComplex(rows, columns, stride, offset);
    }

    public static INDArray create(int rows, int columns, int[] stride, int offset, char ordering) {
        return INSTANCE.create(rows, columns, stride, offset);
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride, int offset, char ordering) {
        return INSTANCE.createComplex(shape, stride, offset);
    }

    public static INDArray create(int[] shape, int[] stride, int offset, char ordering) {
        return INSTANCE.create(shape, stride, offset);
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride, char ordering) {
        return INSTANCE.createComplex(rows, columns, stride);
    }

    public static INDArray create(int rows, int columns, int[] stride, char ordering) {
        return INSTANCE.create(rows, columns, stride);
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride, char ordering) {
        return Nd4j.createComplex(shape, stride, 0);
    }

    public static INDArray create(int[] shape, int[] stride, char ordering) {
        return INSTANCE.create(shape, stride);
    }

    public static IComplexNDArray createComplex(int rows, int columns, char ordering) {
        return INSTANCE.createComplex(rows, columns);
    }

    public static INDArray create(int rows, int columns, char ordering) {
        return INSTANCE.create(rows, columns);
    }

    public static IComplexNDArray createComplex(int[] shape, char ordering) {
        return INSTANCE.createComplex(shape);
    }

    public static INDArray create(int[] shape, char ordering) {
        return INSTANCE.create(shape);
    }

    public static IComplexNDArray createComplex(double[] data, int[] ints, int offset, char ordering) {
        return INSTANCE.createComplex(data, ints, ArrayUtil.calcStrides(ints, 2), offset, ordering);
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int offset) {
        return Nd4j.createComplex(data, shape, offset, Nd4j.order().charValue());
    }

    public static INDArray create(float[] data, int[] shape, int offset) {
        return INSTANCE.create(data, shape, offset);
    }

    public static IComplexNDArray createComplex(float[] data, int[] ints, int offset, char ordering) {
        return INSTANCE.createComplex(data, ints, offset, ordering);
    }

    public static IComplexNDArray createComplex(float[] dim) {
        return INSTANCE.createComplex(dim);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int offset) {
        return INSTANCE.createComplex(data, shape, offset);
    }

    public static INDArray create(float[][] floats) {
        return INSTANCE.create(floats);
    }

    public static IComplexNDArray complexLinSpace(int i, int i1, int i2) {
        return Nd4j.createComplex(Nd4j.linspace(i, i1, i2));
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, char ordering, int offset) {
        return INSTANCE.create(data, shape, stride, offset, ordering);
    }

    public static INDArray create(float[] data, int[] shape, char ordering, int offset) {
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    static {
        ORDER = (char)99;
        props = new Properties();
        try {
            ClassPathResource c = new ClassPathResource(LINALG_PROPS);
            props.load(c.getInputStream());
            dtype = props.get(DTYPE).toString();
            ORDER = props.getProperty(ORDER_KEY, "c").toString().charAt(0);
            ndArrayFactoryClazz = Class.forName(props.get(NDARRAY_FACTORY_CLASS).toString());
            Constructor<? extends NDArrayFactory> c2 = ndArrayFactoryClazz.getConstructor(String.class, Character.class);
            INSTANCE = c2.newInstance(dtype, Character.valueOf(ORDER));
            blasWrapperClazz = Class.forName(props.get(BLAS_OPS).toString());
            BLAS_WRAPPER_INSTANCE = blasWrapperClazz.newInstance();
            UNIT = Nd4j.createFloat(1.0f, 0.0f);
            ZERO = Nd4j.createFloat(1.0f, 0.0f);
            NEG_UNIT = Nd4j.createFloat(-1.0f, 0.0f);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

