/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import java.util.Arrays;
import org.nd4j.linalg.util.ArrayUtil;

public class NDArrayIndex {
    private int[] indices = new int[1];

    public NDArrayIndex(int[] indices) {
        this.indices = indices.length > 0 ? indices : new int[1];
    }

    public int end() {
        return this.indices[this.indices.length - 1];
    }

    public int offset() {
        if (this.indices.length < 1) {
            return 0;
        }
        return this.indices[0];
    }

    public int length() {
        if (this.indices.length < 1) {
            return 0;
        }
        return this.indices[this.indices.length - 1] - this.indices[0];
    }

    public int[] indices() {
        return this.indices;
    }

    public void reverse() {
        ArrayUtil.reverse(this.indices);
    }

    public String toString() {
        return "NDArrayIndex{indices=" + Arrays.toString(this.indices) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NDArrayIndex)) {
            return false;
        }
        NDArrayIndex that = (NDArrayIndex)o;
        return Arrays.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Arrays.hashCode(this.indices);
    }

    public static NDArrayIndex interval(int begin, int end) {
        return NDArrayIndex.interval(begin, end, false);
    }

    public static NDArrayIndex interval(int begin, int end, boolean inclusive) {
        return new NDArrayIndex(ArrayUtil.range(begin, inclusive ? end + 1 : end));
    }
}

