/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.complex;

import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseComplexDouble
implements IComplexDouble {
    protected static double real;
    protected static double imag;

    public BaseComplexDouble(double real, double imag) {
        BaseComplexDouble.real = real;
        BaseComplexDouble.imag = imag;
    }

    public BaseComplexDouble(double real) {
        this(real, imag);
    }

    @Override
    public IComplexDouble asDouble() {
        return this;
    }

    @Override
    public IComplexDouble conji() {
        this.set(this.realComponent(), -this.imaginaryComponent().doubleValue());
        return this;
    }

    @Override
    public IComplexNumber conj() {
        return this.dup().conji();
    }

    @Override
    public IComplexNumber set(Number real, Number imag) {
        BaseComplexDouble.real = real.doubleValue();
        BaseComplexDouble.imag = imag.doubleValue();
        return this;
    }

    @Override
    public IComplexNumber copy(IComplexNumber other) {
        return Nd4j.createDouble(other.realComponent().doubleValue(), other.imaginaryComponent().doubleValue());
    }

    @Override
    public IComplexNumber addi(IComplexNumber c, IComplexNumber result) {
        if (this == result) {
            this.set(this.realComponent() + c.realComponent().doubleValue(), this.imaginaryComponent() + c.imaginaryComponent().doubleValue());
        } else {
            result.set(result.realComponent().doubleValue() + c.realComponent().doubleValue(), result.imaginaryComponent().doubleValue() + c.imaginaryComponent().doubleValue());
        }
        return this;
    }

    @Override
    public IComplexNumber addi(IComplexNumber c) {
        return this.addi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber add(IComplexNumber c) {
        return this.dup().addi(c);
    }

    @Override
    public IComplexNumber addi(Number a, IComplexNumber result) {
        if (this == result) {
            this.set(this.realComponent() + a.doubleValue(), this.imaginaryComponent() + a.doubleValue());
        } else {
            result.set(result.realComponent().doubleValue() + a.doubleValue(), this.imaginaryComponent() + a.doubleValue());
        }
        return result;
    }

    @Override
    public IComplexNumber addi(Number c) {
        return this.addi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber add(Number c) {
        return this.dup().addi(c);
    }

    @Override
    public IComplexNumber subi(IComplexNumber c, IComplexNumber result) {
        if (this == result) {
            this.set(this.realComponent() - c.realComponent().doubleValue(), this.imaginaryComponent() - c.imaginaryComponent().doubleValue());
        } else {
            result.set(result.realComponent().doubleValue() - c.realComponent().doubleValue(), result.imaginaryComponent().doubleValue() - c.imaginaryComponent().doubleValue());
        }
        return this;
    }

    @Override
    public IComplexNumber subi(IComplexNumber c) {
        return this.subi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber sub(IComplexNumber c) {
        return this.dup().subi(c);
    }

    @Override
    public IComplexNumber subi(Number a, IComplexNumber result) {
        if (this == result) {
            this.set(this.realComponent() - a.doubleValue(), this.imaginaryComponent() - a.doubleValue());
        } else {
            result.set(result.realComponent().doubleValue() - a.doubleValue(), this.imaginaryComponent() - a.doubleValue());
        }
        return result;
    }

    @Override
    public IComplexNumber subi(Number a) {
        return this.subi(a, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber sub(Number r) {
        return this.dup().subi(r);
    }

    @Override
    public IComplexNumber muli(IComplexNumber c, IComplexNumber result) {
        double newR = real * c.realComponent().doubleValue() - imag * c.imaginaryComponent().doubleValue();
        double newI = real * c.imaginaryComponent().doubleValue() + imag * c.realComponent().doubleValue();
        result.set(newR, newI);
        return result;
    }

    @Override
    public IComplexNumber muli(IComplexNumber c) {
        return this.muli(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber mul(IComplexNumber c) {
        return this.dup().muli(c);
    }

    @Override
    public IComplexNumber mul(Number v) {
        return this.dup().muli(v);
    }

    @Override
    public IComplexNumber muli(Number v, IComplexNumber result) {
        if (this == result) {
            this.set(this.realComponent() * v.doubleValue(), this.imaginaryComponent() * v.doubleValue());
        } else {
            result.set(result.realComponent().doubleValue() * v.doubleValue(), this.imaginaryComponent() * v.doubleValue());
        }
        return result;
    }

    @Override
    public IComplexNumber muli(Number v) {
        return this.muli(v, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber div(IComplexNumber c) {
        return this.dup().divi(c);
    }

    @Override
    public IComplexNumber divi(IComplexNumber c, IComplexNumber result) {
        double d = c.realComponent().doubleValue() * c.realComponent().doubleValue() + c.imaginaryComponent().doubleValue() * c.imaginaryComponent().doubleValue();
        double newR = (this.realComponent() * c.realComponent().doubleValue() + this.imaginaryComponent() * c.imaginaryComponent().doubleValue()) / d;
        double newI = (this.imaginaryComponent() * c.realComponent().doubleValue() - this.realComponent() * c.imaginaryComponent().doubleValue()) / d;
        result.set(newR, newI);
        return result;
    }

    @Override
    public IComplexNumber divi(IComplexNumber c) {
        return this.divi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber divi(Number v, IComplexNumber result) {
        if (this == result) {
            this.set(this.realComponent() / v.doubleValue(), this.imaginaryComponent() / v.doubleValue());
        } else {
            result.set(result.realComponent().doubleValue() / v.doubleValue(), result.imaginaryComponent().doubleValue() / v.doubleValue());
        }
        return result;
    }

    @Override
    public IComplexNumber divi(Number v) {
        return this.divi(v, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber div(Number v) {
        return this.dup().divi(v);
    }

    @Override
    public boolean eq(IComplexNumber c) {
        return this.realComponent().equals(c.realComponent()) && this.imaginaryComponent().equals(c.imaginaryComponent());
    }

    @Override
    public boolean ne(IComplexNumber c) {
        return !this.eq(c);
    }

    @Override
    public boolean isZero() {
        return real == 0.0;
    }

    @Override
    public boolean isReal() {
        return imag == 0.0;
    }

    @Override
    public boolean isImag() {
        return real == 0.0;
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public Double realComponent() {
        return real;
    }

    @Override
    public Double imaginaryComponent() {
        return imag;
    }

    @Override
    public IComplexDouble divi(double v) {
        imag /= v;
        real /= v;
        return this;
    }

    @Override
    public IComplexNumber div(double v) {
        return this.dup().divi(v);
    }

    @Override
    public Double absoluteValue() {
        return Math.sqrt(real * real + imag * imag);
    }

    @Override
    public Double complexArgument() {
        return Math.acos(this.realComponent() / this.absoluteValue());
    }

    @Override
    public IComplexDouble invi() {
        double d = this.realComponent() * this.realComponent() + this.imaginaryComponent() * this.imaginaryComponent();
        this.set(this.realComponent() / d, -this.imaginaryComponent().doubleValue() / d);
        return this;
    }

    @Override
    public IComplexNumber inv() {
        return this.dup().invi();
    }

    @Override
    public IComplexNumber neg() {
        return this.dup().negi();
    }

    @Override
    public IComplexDouble negi() {
        this.set(-this.realComponent().doubleValue(), -this.imaginaryComponent().doubleValue());
        return this;
    }

    @Override
    public IComplexDouble sqrt() {
        double a = this.absoluteValue();
        double s2 = Math.sqrt(2.0);
        double p = Math.sqrt(a + this.realComponent()) / s2;
        double q = Math.sqrt(a - this.realComponent()) / s2 * Math.signum(this.imaginaryComponent());
        return Nd4j.createDouble(p, q);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }
}

