/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.datatype.joda.ser;

import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.SerializerProvider;
import org.nd4j.shade.jackson.datatype.joda.cfg.FormatConfig;
import org.nd4j.shade.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import org.nd4j.shade.jackson.datatype.joda.ser.JodaDateSerializerBase;

public final class DateTimeSerializer
extends JodaDateSerializerBase<DateTime> {
    private static final long serialVersionUID = 1L;

    public DateTimeSerializer() {
        this(FormatConfig.DEFAULT_DATETIME_FORMAT);
    }

    public DateTimeSerializer(JacksonJodaDateFormat format) {
        super(DateTime.class, format, false, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public DateTimeSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new DateTimeSerializer(formatter);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, DateTime value) {
        return value.getMillis() == 0L;
    }

    @Override
    public void serialize(DateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._useTimestamp(provider)) {
            gen.writeNumber(value.getMillis());
        } else {
            gen.writeString(this._format.createFormatter(provider).print((ReadableInstant)value));
        }
    }
}

