/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.datatype.joda.deser;

import java.io.IOException;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonToken;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.datatype.joda.deser.JodaDeserializerBase;

public class DateTimeDeserializer
extends JodaDeserializerBase<ReadableInstant> {
    private static final long serialVersionUID = 1L;

    public DateTimeDeserializer(Class<? extends ReadableInstant> cls) {
        super(cls);
    }

    public static <T extends ReadableInstant> JsonDeserializer<T> forType(Class<T> cls) {
        return new DateTimeDeserializer((Class<? extends ReadableInstant>)cls);
    }

    @Override
    public ReadableDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            TimeZone tz = ctxt.getTimeZone();
            DateTimeZone dtz = tz == null ? DateTimeZone.UTC : DateTimeZone.forTimeZone((TimeZone)tz);
            return new DateTime(jp.getLongValue(), dtz);
        }
        if (t == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            if (str.length() == 0) {
                return null;
            }
            if (ctxt.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE)) {
                TimeZone tz = ctxt.getTimeZone();
                DateTimeZone dtz = tz == null ? DateTimeZone.UTC : DateTimeZone.forTimeZone((TimeZone)tz);
                return new DateTime((Object)str, dtz);
            }
            return DateTime.parse((String)str);
        }
        throw ctxt.mappingException(this.handledType());
    }
}

