/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.dataformat.xml.deser;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.databind.BeanProperty;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JavaType;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonMappingException;
import org.nd4j.shade.jackson.databind.PropertyName;
import org.nd4j.shade.jackson.databind.deser.BeanDeserializerBase;
import org.nd4j.shade.jackson.databind.deser.SettableBeanProperty;
import org.nd4j.shade.jackson.databind.deser.std.DelegatingDeserializer;
import org.nd4j.shade.jackson.databind.jsontype.TypeDeserializer;
import org.nd4j.shade.jackson.dataformat.xml.deser.FromXmlParser;
import org.nd4j.shade.jackson.dataformat.xml.util.TypeUtil;

public class WrapperHandlingDeserializer
extends DelegatingDeserializer {
    private static final long serialVersionUID = 1L;
    protected final Set<String> _namesToWrap;
    protected final JavaType _type;

    public WrapperHandlingDeserializer(BeanDeserializerBase delegate) {
        this(delegate, null);
    }

    public WrapperHandlingDeserializer(BeanDeserializerBase delegate, Set<String> namesToWrap) {
        super(delegate);
        this._namesToWrap = namesToWrap;
        this._type = delegate.getValueType();
    }

    @Override
    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee0) {
        throw new IllegalStateException("Internal error: should never get called");
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<?> del = ctxt.handleSecondaryContextualization(this._delegatee, property);
        BeanDeserializerBase newDelegatee = this._verifyDeserType(del);
        Iterator<SettableBeanProperty> it = newDelegatee.properties();
        HashSet<String> unwrappedNames = null;
        while (it.hasNext()) {
            PropertyName wrapperName;
            SettableBeanProperty prop = it.next();
            JavaType type = prop.getType();
            if (!TypeUtil.isIndexedType(type) || (wrapperName = prop.getWrapperName()) != null && wrapperName != PropertyName.NO_NAME) continue;
            if (unwrappedNames == null) {
                unwrappedNames = new HashSet<String>();
            }
            unwrappedNames.add(prop.getName());
        }
        if (unwrappedNames == null) {
            return newDelegatee;
        }
        return new WrapperHandlingDeserializer(newDelegatee, unwrappedNames);
    }

    @Override
    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        this._configureParser(jp);
        return this._delegatee.deserialize(jp, ctxt);
    }

    @Override
    public Object deserialize(JsonParser jp, DeserializationContext ctxt, Object intoValue) throws IOException {
        this._configureParser(jp);
        return this._delegatee.deserialize(jp, ctxt, intoValue);
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        this._configureParser(jp);
        return this._delegatee.deserializeWithType(jp, ctxt, typeDeserializer);
    }

    protected final void _configureParser(JsonParser jp) throws IOException {
        if (jp instanceof FromXmlParser) {
            ((FromXmlParser)jp).addVirtualWrapping(this._namesToWrap);
        }
    }

    protected BeanDeserializerBase _verifyDeserType(JsonDeserializer<?> deser) {
        if (!(deser instanceof BeanDeserializerBase)) {
            throw new IllegalArgumentException("Can not change delegate to be of type " + deser.getClass().getName());
        }
        return (BeanDeserializerBase)deser;
    }
}

