/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sos.converter;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.n52.iceland.convert.RequestResponseModifierFacilitator;
import org.n52.iceland.convert.RequestResponseModifierKey;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.ows.exception.InvalidParameterValueException;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesRequest;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.sos.SosOffering;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityRequest;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityResponse;
import org.n52.shetland.ogc.sos.request.DescribeSensorRequest;
import org.n52.shetland.ogc.sos.request.GetFeatureOfInterestRequest;
import org.n52.shetland.ogc.sos.request.GetObservationByIdRequest;
import org.n52.shetland.ogc.sos.request.GetObservationRequest;
import org.n52.shetland.ogc.sos.request.GetResultRequest;
import org.n52.shetland.ogc.sos.request.GetResultTemplateRequest;
import org.n52.shetland.ogc.sos.response.DescribeSensorResponse;
import org.n52.shetland.ogc.sos.response.GetFeatureOfInterestResponse;
import org.n52.shetland.ogc.sos.response.GetObservationByIdResponse;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.n52.shetland.ogc.sos.response.GetResultResponse;
import org.n52.shetland.ogc.sos.response.GetResultTemplateResponse;
import org.n52.sos.convert.AbstractIdentifierModifier;
import org.n52.sos.converter.util.FlexibleIdentifierHelper;

public class FlexibleIdentifierModifier
extends AbstractIdentifierModifier {
    private static final Set<RequestResponseModifierKey> REQUEST_RESPONSE_MODIFIER_KEY_TYPES = FlexibleIdentifierModifier.getKeyTypes();
    @Inject
    private FlexibleIdentifierHelper flexibleIdentifierHelper;

    private static Set<RequestResponseModifierKey> getKeyTypes() {
        HashSet services = Sets.newHashSet((Object[])new String[]{"SOS"});
        HashSet versions = Sets.newHashSet((Object[])new String[]{"1.0.0", "2.0.0"});
        HashMap requestResponseMap = Maps.newHashMap();
        requestResponseMap.put(new GetCapabilitiesRequest("SOS"), new GetCapabilitiesResponse());
        requestResponseMap.put(new GetObservationRequest(), new GetObservationResponse());
        requestResponseMap.put(new GetObservationByIdRequest(), new GetObservationByIdResponse());
        requestResponseMap.put(new GetFeatureOfInterestRequest(), new GetFeatureOfInterestResponse());
        requestResponseMap.put(new DescribeSensorRequest(), new DescribeSensorResponse());
        requestResponseMap.put(new GetDataAvailabilityRequest(), new GetDataAvailabilityResponse());
        requestResponseMap.put(new GetResultTemplateRequest(), new GetResultTemplateResponse());
        requestResponseMap.put(new GetResultRequest(), new GetResultResponse());
        HashSet keys = Sets.newHashSet();
        for (String service : services) {
            for (String version : versions) {
                for (Map.Entry entry : requestResponseMap.entrySet()) {
                    keys.add(new RequestResponseModifierKey(service, version, (OwsServiceRequest)entry.getKey()));
                    keys.add(new RequestResponseModifierKey(service, version, (OwsServiceRequest)entry.getKey(), (OwsServiceResponse)requestResponseMap.get(entry.getKey())));
                }
            }
        }
        return keys;
    }

    public Set<RequestResponseModifierKey> getKeys() {
        return Collections.unmodifiableSet(REQUEST_RESPONSE_MODIFIER_KEY_TYPES);
    }

    protected boolean checkForFlag(OwsServiceRequest request, OwsServiceResponse response) throws InvalidParameterValueException {
        if (this.getFlexibleIdentifierHelper().checkIsReturnHumanReadableIdentifierFlagExtensionSet(request.getExtensions()) || this.getFlexibleIdentifierHelper().checkIsReturnHumanReadableIdentifierFlagExtensionSet(response.getExtensions())) {
            return this.checkResponseForReturnHumanReadableIdentifierFlag(response) || this.checkRequestForReturnHumanReadableIdentifierFlag(request);
        }
        return this.getFlexibleIdentifierHelper().isSetReturnHumanReadableIdentifier();
    }

    private boolean checkResponseForReturnHumanReadableIdentifierFlag(OwsServiceResponse response) throws InvalidParameterValueException {
        return this.getFlexibleIdentifierHelper().checkForReturnHumanReadableIdentifierFlagExtension(response.getExtensions());
    }

    private boolean checkRequestForReturnHumanReadableIdentifierFlag(OwsServiceRequest request) throws InvalidParameterValueException {
        return this.getFlexibleIdentifierHelper().checkForReturnHumanReadableIdentifierFlagExtension(request.getExtensions());
    }

    protected String checkOfferingParameterValue(String parameterValue) {
        return this.getCache().getOfferingIdentifierForHumanReadableName(parameterValue);
    }

    protected String checkFeatureOfInterestParameterValue(String parameterValue) {
        return this.getCache().getFeatureOfInterestIdentifierForHumanReadableName(parameterValue);
    }

    protected String checkObservablePropertyParameterValue(String parameterValue) {
        return this.getCache().getObservablePropertyIdentifierForHumanReadableName(parameterValue);
    }

    protected String checkProcedureParameterValue(String parameterValue) {
        return this.getCache().getProcedureIdentifierForHumanReadableName(parameterValue);
    }

    protected String checkFeatureOfInterestIdentifier(String identifier) {
        if (this.getFlexibleIdentifierHelper().isSetIncludeFeatureOfInterest()) {
            return this.getCache().getFeatureOfInterestHumanReadableNameForIdentifier(identifier);
        }
        return identifier;
    }

    protected String checkObservablePropertyIdentifier(String identifier) {
        if (this.getFlexibleIdentifierHelper().isSetIncludeObservableProperty()) {
            return this.getCache().getObservablePropertyHumanReadableNameForIdentifier(identifier);
        }
        return identifier;
    }

    protected String checkProcedureIdentifier(String identifier) {
        if (this.getFlexibleIdentifierHelper().isSetIncludeProcedure()) {
            return this.getCache().getProcedureHumanReadableNameForIdentifier(identifier);
        }
        return identifier;
    }

    protected ReferenceType checkProcedureIdentifier(ReferenceType procedure) {
        return new ReferenceType(this.checkProcedureIdentifier(procedure.getHref()));
    }

    protected String checkOfferingIdentifier(String identifier) {
        if (this.getFlexibleIdentifierHelper().isSetIncludeOffering()) {
            return this.getCache().getOfferingHumanReadableNameForIdentifier(identifier);
        }
        return identifier;
    }

    protected void checkAndChangeFeatureOfInterestIdentifier(AbstractFeature abstractFeature) {
        if (this.getFlexibleIdentifierHelper().isSetIncludeFeatureOfInterest()) {
            this.checkAndChangeIdentifierOfAbstractFeature(abstractFeature);
        }
    }

    protected void checkAndChangeProcedureIdentifier(AbstractFeature abstractFeature) {
        if (this.getFlexibleIdentifierHelper().isSetIncludeProcedure()) {
            if (!abstractFeature.isSetHumanReadableIdentifier()) {
                abstractFeature.setHumanReadableIdentifier(this.checkProcedureIdentifier(abstractFeature.getIdentifier()));
            }
            abstractFeature.setHumanReadableIdentifierAsIdentifier();
        }
    }

    protected void checkAndChangeObservablePropertyIdentifier(AbstractFeature abstractFeature) {
        if (this.getFlexibleIdentifierHelper().isSetIncludeObservableProperty()) {
            if (!abstractFeature.isSetHumanReadableIdentifier()) {
                abstractFeature.setHumanReadableIdentifier(this.checkObservablePropertyIdentifier(abstractFeature.getIdentifier()));
            }
            abstractFeature.setHumanReadableIdentifierAsIdentifier();
        }
    }

    protected void checkAndChangOfferingIdentifier(SosOffering offering) {
        if (offering != null && this.getFlexibleIdentifierHelper().isSetIncludeOffering()) {
            if (!offering.isSetHumanReadableIdentifier()) {
                offering.setHumanReadableIdentifier(this.checkOfferingIdentifier(offering.getIdentifier()));
            }
            offering.setHumanReadableIdentifierAsIdentifier();
        }
    }

    private void checkAndChangeIdentifierOfAbstractFeature(AbstractFeature abstractFeature) {
        if (!abstractFeature.isSetHumanReadableIdentifier()) {
            abstractFeature.setHumanReadableIdentifier(this.checkFeatureOfInterestIdentifier(abstractFeature.getIdentifier()));
        }
        abstractFeature.setHumanReadableIdentifierAsIdentifier();
        if (abstractFeature.isSetXml()) {
            abstractFeature.setXml(null);
        }
    }

    protected FlexibleIdentifierHelper getFlexibleIdentifierHelper() {
        return this.flexibleIdentifierHelper;
    }

    public RequestResponseModifierFacilitator getFacilitator() {
        return super.getFacilitator().setAdderRemover(false);
    }
}

