/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.boot.test.autoconfigure;

import java.util.Collections;
import java.util.Set;
import org.mybatis.spring.boot.test.autoconfigure.MybatisTest;
import org.springframework.boot.test.autoconfigure.filter.AnnotationCustomizableTypeExcludeFilter;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotatedElementUtils;

class MybatisTypeExcludeFilter
extends AnnotationCustomizableTypeExcludeFilter {
    private final MybatisTest annotation;

    MybatisTypeExcludeFilter(Class<?> testClass) {
        this.annotation = (MybatisTest)AnnotatedElementUtils.getMergedAnnotation(testClass, MybatisTest.class);
    }

    protected boolean hasAnnotation() {
        return this.annotation != null;
    }

    protected ComponentScan.Filter[] getFilters(AnnotationCustomizableTypeExcludeFilter.FilterType type) {
        switch (type) {
            case INCLUDE: {
                return this.annotation.includeFilters();
            }
            case EXCLUDE: {
                return this.annotation.excludeFilters();
            }
        }
        throw new IllegalStateException("Unsupported type " + type);
    }

    protected boolean isUseDefaultFilters() {
        return this.annotation.useDefaultFilters();
    }

    protected Set<Class<?>> getDefaultIncludes() {
        return Collections.emptySet();
    }

    protected Set<Class<?>> getComponentIncludes() {
        return Collections.emptySet();
    }
}

