/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ResultObjectFactoryUtil {
    private static ThreadLocal<Deque<FactorySettings>> factorySettings = new ThreadLocal();

    private ResultObjectFactoryUtil() {
    }

    public static Object createObjectThroughFactory(Class clazz) throws InstantiationException, IllegalAccessException {
        Object obj;
        FactorySettings fs = ResultObjectFactoryUtil.getCurrentFactorySettings();
        if (fs.getResultObjectFactory() == null) {
            obj = ResultObjectFactoryUtil.createObjectInternally(clazz);
        } else {
            obj = fs.getResultObjectFactory().createInstance(fs.getStatementId(), clazz);
            if (obj == null) {
                obj = ResultObjectFactoryUtil.createObjectInternally(clazz);
            }
        }
        return obj;
    }

    private static Object createObjectInternally(Class clazz) throws InstantiationException, IllegalAccessException {
        Class classToCreate = clazz == List.class || clazz == Collection.class ? ArrayList.class : (clazz == Set.class ? HashSet.class : clazz);
        return Resources.instantiate(classToCreate);
    }

    public static void setupResultObjectFactory(ResultObjectFactory resultObjectFactory, String statementId) {
        Deque<FactorySettings> fss = factorySettings.get();
        if (fss == null) {
            fss = new ArrayDeque<FactorySettings>();
            factorySettings.set(fss);
        }
        FactorySettings fs = new FactorySettings();
        fs.setResultObjectFactory(resultObjectFactory);
        fs.setStatementId(statementId);
        fss.push(fs);
    }

    public static void cleanupResultObjectFactory() {
        Deque<FactorySettings> fss = factorySettings.get();
        if (!fss.isEmpty()) {
            fss.pop();
        }
        if (fss.isEmpty()) {
            factorySettings.remove();
        }
    }

    private static FactorySettings getCurrentFactorySettings() {
        Deque<FactorySettings> fss = factorySettings.get();
        FactorySettings fs = fss == null || fss.isEmpty() ? new FactorySettings() : fss.peek();
        return fs;
    }

    private static class FactorySettings {
        private ResultObjectFactory resultObjectFactory;
        private String statementId;

        private FactorySettings() {
        }

        public ResultObjectFactory getResultObjectFactory() {
            return this.resultObjectFactory;
        }

        public void setResultObjectFactory(ResultObjectFactory resultObjectFactory) {
            this.resultObjectFactory = resultObjectFactory;
        }

        public String getStatementId() {
            return this.statementId;
        }

        public void setStatementId(String statementId) {
            this.statementId = statementId;
        }
    }
}

