/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.config;

import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;
import com.ibatis.sqlmap.engine.config.SqlMapConfiguration;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.result.Discriminator;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.type.CustomTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ResultMapConfig {
    private SqlMapConfiguration config;
    private ErrorContext errorContext;
    private SqlMapClientImpl client;
    private SqlMapExecutorDelegate delegate;
    private TypeHandlerFactory typeHandlerFactory;
    private ResultMap resultMap;
    private List resultMappingList;
    private int resultMappingIndex;
    private Discriminator discriminator;

    ResultMapConfig(SqlMapConfiguration config, String id, Class resultClass, String groupBy, String extendsResultMap, String xmlName) {
        this.config = config;
        this.errorContext = config.getErrorContext();
        this.client = config.getClient();
        this.delegate = config.getDelegate();
        this.typeHandlerFactory = config.getTypeHandlerFactory();
        this.resultMap = new ResultMap(this.client.getDelegate());
        this.resultMappingList = new ArrayList();
        this.errorContext.setActivity("building a result map");
        this.errorContext.setObjectId(id + " result map");
        this.resultMap.setId(id);
        this.resultMap.setXmlName(xmlName);
        this.resultMap.setResource(this.errorContext.getResource());
        if (groupBy != null && groupBy.length() > 0) {
            StringTokenizer parser = new StringTokenizer(groupBy, ", ", false);
            while (parser.hasMoreTokens()) {
                this.resultMap.addGroupByProperty(parser.nextToken());
            }
        }
        this.resultMap.setResultClass(resultClass);
        this.errorContext.setMoreInfo("Check the extended result map.");
        if (extendsResultMap != null) {
            ResultMap extendedResultMap = this.client.getDelegate().getResultMap(extendsResultMap);
            ResultMapping[] resultMappings = extendedResultMap.getResultMappings();
            for (int i = 0; i < resultMappings.length; ++i) {
                this.resultMappingList.add(resultMappings[i]);
            }
            List nestedResultMappings = extendedResultMap.getNestedResultMappings();
            if (nestedResultMappings != null) {
                Iterator iter = nestedResultMappings.iterator();
                while (iter.hasNext()) {
                    this.resultMap.addNestedResultMappings((ResultMapping)iter.next());
                }
            }
            if ((groupBy == null || groupBy.length() == 0) && extendedResultMap.hasGroupBy()) {
                Iterator i = extendedResultMap.groupByProps();
                while (i.hasNext()) {
                    this.resultMap.addGroupByProperty((String)i.next());
                }
            }
        }
        this.errorContext.setMoreInfo("Check the result mappings.");
        this.resultMappingIndex = this.resultMappingList.size();
        this.resultMap.setResultMappingList(this.resultMappingList);
        this.client.getDelegate().addResultMap(this.resultMap);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDiscriminator(String columnName, Integer columnIndex, Class javaClass, String jdbcType, String nullValue, Object typeHandlerImpl) {
        void var7_10;
        if (typeHandlerImpl != null) {
            if (typeHandlerImpl instanceof TypeHandlerCallback) {
                CustomTypeHandler customTypeHandler = new CustomTypeHandler((TypeHandlerCallback)typeHandlerImpl);
            } else {
                if (!(typeHandlerImpl instanceof TypeHandler)) throw new RuntimeException("The class '' is not a valid implementation of TypeHandler or TypeHandlerCallback");
                TypeHandler typeHandler = (TypeHandler)typeHandlerImpl;
            }
        } else {
            TypeHandler typeHandler = this.config.resolveTypeHandler(this.client.getDelegate().getTypeHandlerFactory(), this.resultMap.getResultClass(), "", javaClass, jdbcType, true);
        }
        ResultMapping mapping = new ResultMapping();
        mapping.setColumnName(columnName);
        mapping.setJdbcTypeName(jdbcType);
        mapping.setTypeHandler((TypeHandler)var7_10);
        mapping.setNullValue(nullValue);
        mapping.setJavaType(javaClass);
        if (columnIndex != null) {
            mapping.setColumnIndex(columnIndex);
        }
        this.discriminator = new Discriminator(this.delegate, mapping);
        this.resultMap.setDiscriminator(this.discriminator);
    }

    public void addDiscriminatorSubMap(Object value, String resultMap) {
        if (this.discriminator == null) {
            throw new RuntimeException("The discriminator is null, but somehow a subMap was reached.  This is a bug.");
        }
        this.discriminator.addSubMap(value.toString(), resultMap);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addResultMapping(String propertyName, String columnName, Integer columnIndex, Class javaClass, String jdbcType, String nullValue, String notNullColumn, String statementName, String resultMapName, Object impl) {
        void var11_14;
        this.errorContext.setObjectId(propertyName + " mapping of the " + this.resultMap.getId() + " result map");
        if (impl != null) {
            if (impl instanceof TypeHandlerCallback) {
                CustomTypeHandler customTypeHandler = new CustomTypeHandler((TypeHandlerCallback)impl);
            } else {
                if (!(impl instanceof TypeHandler)) throw new RuntimeException("The class '" + String.valueOf(impl) + "' is not a valid implementation of TypeHandler or TypeHandlerCallback");
                TypeHandler typeHandler = (TypeHandler)impl;
            }
        } else {
            TypeHandler typeHandler = this.config.resolveTypeHandler(this.client.getDelegate().getTypeHandlerFactory(), this.resultMap.getResultClass(), propertyName, javaClass, jdbcType, true);
        }
        ResultMapping mapping = new ResultMapping();
        mapping.setPropertyName(propertyName);
        mapping.setColumnName(columnName);
        mapping.setJdbcTypeName(jdbcType);
        mapping.setTypeHandler((TypeHandler)var11_14);
        mapping.setNullValue(nullValue);
        mapping.setNotNullColumn(notNullColumn);
        mapping.setStatementName(statementName);
        mapping.setNestedResultMapName(resultMapName);
        if (resultMapName != null && resultMapName.length() > 0) {
            this.resultMap.addNestedResultMappings(mapping);
        }
        mapping.setJavaType(javaClass);
        if (columnIndex != null) {
            mapping.setColumnIndex(columnIndex);
        } else {
            ++this.resultMappingIndex;
            mapping.setColumnIndex(this.resultMappingIndex);
        }
        this.resultMappingList.add(mapping);
        this.resultMap.setResultMappingList(this.resultMappingList);
    }
}

