/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.builder.xml;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.engine.config.CacheModelConfig;
import com.ibatis.sqlmap.engine.config.ParameterMapConfig;
import com.ibatis.sqlmap.engine.config.ResultMapConfig;
import com.ibatis.sqlmap.engine.config.SqlMapConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;

public class XmlParserState {
    private SqlMapConfiguration config = new SqlMapConfiguration();
    private Properties globalProps = new Properties();
    private Properties txProps = new Properties();
    private Properties dsProps = new Properties();
    private Properties cacheProps = new Properties();
    private boolean useStatementNamespaces = false;
    private Map sqlIncludes = new HashMap();
    private ParameterMapConfig paramConfig;
    private ResultMapConfig resultConfig;
    private CacheModelConfig cacheConfig;
    private String namespace;
    private DataSource dataSource;

    public SqlMapConfiguration getConfig() {
        return this.config;
    }

    public void setGlobalProps(Properties props) {
        this.globalProps = props;
    }

    public Properties getGlobalProps() {
        return this.globalProps;
    }

    public Properties getTxProps() {
        return this.txProps;
    }

    public Properties getDsProps() {
        return this.dsProps;
    }

    public Properties getCacheProps() {
        return this.cacheProps;
    }

    public void setUseStatementNamespaces(boolean useStatementNamespaces) {
        this.useStatementNamespaces = useStatementNamespaces;
    }

    public boolean isUseStatementNamespaces() {
        return this.useStatementNamespaces;
    }

    public Map getSqlIncludes() {
        return this.sqlIncludes;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String applyNamespace(String id) {
        Object newId = id;
        if (this.namespace != null && this.namespace.length() > 0 && id != null && id.indexOf(46) < 0) {
            newId = this.namespace + "." + id;
        }
        return newId;
    }

    public CacheModelConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public void setCacheConfig(CacheModelConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    public ParameterMapConfig getParamConfig() {
        return this.paramConfig;
    }

    public void setParamConfig(ParameterMapConfig paramConfig) {
        this.paramConfig = paramConfig;
    }

    public ResultMapConfig getResultConfig() {
        return this.resultConfig;
    }

    public void setResultConfig(ResultMapConfig resultConfig) {
        this.resultConfig = resultConfig;
    }

    public String getFirstToken(String s) {
        return new StringTokenizer(s, ", ", false).nextToken();
    }

    public String[] getAllButFirstToken(String s) {
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer parser = new StringTokenizer(s, ", ", false);
        parser.nextToken();
        while (parser.hasMoreTokens()) {
            strings.add(parser.nextToken());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public void setGlobalProperties(String resource, String url) {
        this.config.getErrorContext().setActivity("loading global properties");
        try {
            Properties props;
            if (resource != null) {
                this.config.getErrorContext().setResource(resource);
                props = Resources.getResourceAsProperties(resource);
            } else if (url != null) {
                this.config.getErrorContext().setResource(url);
                props = Resources.getUrlAsProperties(url);
            } else {
                throw new RuntimeException("The properties element requires either a resource or a url attribute.");
            }
            if (props != null) {
                props.putAll((Map<?, ?>)this.globalProps);
                this.globalProps = props;
            }
            String customizedSQLExecutor = this.globalProps.getProperty("sql_executor_class");
            this.config.getErrorContext().setActivity("Loading SQLExecutor.");
            if (customizedSQLExecutor != null) {
                try {
                    this.config.getClient().getDelegate().setCustomExecutor(customizedSQLExecutor);
                    this.config.getClient().getDelegate().getSqlExecutor().init(this.config, this.globalProps);
                }
                catch (Exception e) {
                    this.config.getErrorContext().setCause(e);
                    this.config.getErrorContext().setMoreInfo("Loading of customizedSQLExecutor failed. Please check Properties file.");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading properties.  Cause: " + String.valueOf(e), e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

