/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.builder.xml;

import com.ibatis.common.resources.Resources;
import com.ibatis.common.xml.Nodelet;
import com.ibatis.common.xml.NodeletException;
import com.ibatis.common.xml.NodeletParser;
import com.ibatis.common.xml.NodeletUtils;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapClasspathEntityResolver;
import com.ibatis.sqlmap.engine.builder.xml.SqlStatementParser;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.config.CacheModelConfig;
import com.ibatis.sqlmap.engine.config.ParameterMapConfig;
import com.ibatis.sqlmap.engine.config.ResultMapConfig;
import com.ibatis.sqlmap.engine.mapping.statement.DeleteStatement;
import com.ibatis.sqlmap.engine.mapping.statement.InsertStatement;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.ProcedureStatement;
import com.ibatis.sqlmap.engine.mapping.statement.SelectStatement;
import com.ibatis.sqlmap.engine.mapping.statement.UpdateStatement;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import org.w3c.dom.Node;

public class SqlMapParser {
    private final NodeletParser parser = new NodeletParser();
    private XmlParserState state;
    private SqlStatementParser statementParser;

    public SqlMapParser(XmlParserState state) {
        this.state = state;
        this.parser.setValidation(true);
        this.parser.setEntityResolver(new SqlMapClasspathEntityResolver());
        this.statementParser = new SqlStatementParser(this.state);
        this.addSqlMapNodelets();
        this.addSqlNodelets();
        this.addTypeAliasNodelets();
        this.addCacheModelNodelets();
        this.addParameterMapNodelets();
        this.addResultMapNodelets();
        this.addStatementNodelets();
    }

    public void parse(Reader reader) throws NodeletException {
        this.parser.parse(reader);
    }

    public void parse(InputStream inputStream) throws NodeletException {
        this.parser.parse(inputStream);
    }

    private void addSqlMapNodelets() {
        this.parser.addNodelet("/sqlMap", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                SqlMapParser.this.state.setNamespace(attributes.getProperty("namespace"));
            }
        });
    }

    private void addSqlNodelets() {
        this.parser.addNodelet("/sqlMap/sql", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                String id = attributes.getProperty("id");
                if (SqlMapParser.this.state.isUseStatementNamespaces()) {
                    id = SqlMapParser.this.state.applyNamespace(id);
                }
                if (SqlMapParser.this.state.getSqlIncludes().containsKey(id)) {
                    throw new SqlMapException("Duplicate <sql>-include '" + id + "' found.");
                }
                SqlMapParser.this.state.getSqlIncludes().put(id, node);
            }
        });
    }

    private void addTypeAliasNodelets() {
        this.parser.addNodelet("/sqlMap/typeAlias", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties prop = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                String alias = prop.getProperty("alias");
                String type = prop.getProperty("type");
                SqlMapParser.this.state.getConfig().getTypeHandlerFactory().putTypeAlias(alias, type);
            }
        });
    }

    private void addCacheModelNodelets() {
        this.parser.addNodelet("/sqlMap/cacheModel", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                String id = SqlMapParser.this.state.applyNamespace(attributes.getProperty("id"));
                String type = attributes.getProperty("type");
                String readOnlyAttr = attributes.getProperty("readOnly");
                Boolean readOnly = readOnlyAttr == null || readOnlyAttr.length() <= 0 ? null : new Boolean("true".equals(readOnlyAttr));
                String serializeAttr = attributes.getProperty("serialize");
                Boolean serialize = serializeAttr == null || serializeAttr.length() <= 0 ? null : new Boolean("true".equals(serializeAttr));
                type = SqlMapParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(type);
                Class clazz = Resources.classForName(type);
                if (readOnly == null) {
                    readOnly = Boolean.TRUE;
                }
                if (serialize == null) {
                    serialize = Boolean.FALSE;
                }
                CacheModelConfig cacheConfig = SqlMapParser.this.state.getConfig().newCacheModelConfig(id, (CacheController)Resources.instantiate(clazz), readOnly, serialize);
                SqlMapParser.this.state.setCacheConfig(cacheConfig);
            }
        });
        this.parser.addNodelet("/sqlMap/cacheModel/end()", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapParser.this.state.getCacheConfig().setControllerProperties(SqlMapParser.this.state.getCacheProps());
            }
        });
        this.parser.addNodelet("/sqlMap/cacheModel/property", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the cache model properties.");
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                String name = attributes.getProperty("name");
                String value = NodeletUtils.parsePropertyTokens(attributes.getProperty("value"), SqlMapParser.this.state.getGlobalProps());
                SqlMapParser.this.state.getCacheProps().setProperty(name, value);
            }
        });
        this.parser.addNodelet("/sqlMap/cacheModel/flushOnExecute", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties childAttributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                String statement = childAttributes.getProperty("statement");
                SqlMapParser.this.state.getCacheConfig().addFlushTriggerStatement(statement);
            }
        });
        this.parser.addNodelet("/sqlMap/cacheModel/flushInterval", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties childAttributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                try {
                    int milliseconds = childAttributes.getProperty("milliseconds") == null ? 0 : Integer.parseInt(childAttributes.getProperty("milliseconds"));
                    int seconds = childAttributes.getProperty("seconds") == null ? 0 : Integer.parseInt(childAttributes.getProperty("seconds"));
                    int minutes = childAttributes.getProperty("minutes") == null ? 0 : Integer.parseInt(childAttributes.getProperty("minutes"));
                    int hours = childAttributes.getProperty("hours") == null ? 0 : Integer.parseInt(childAttributes.getProperty("hours"));
                    SqlMapParser.this.state.getCacheConfig().setFlushInterval(hours, minutes, seconds, milliseconds);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Error building cache in 'resourceNAME'.  Flush interval milliseconds must be a valid long integer value.  Cause: " + String.valueOf(e), e);
                }
            }
        });
    }

    private void addParameterMapNodelets() {
        this.parser.addNodelet("/sqlMap/parameterMap/end()", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapParser.this.state.getConfig().getErrorContext().setMoreInfo(null);
                SqlMapParser.this.state.getConfig().getErrorContext().setObjectId(null);
                SqlMapParser.this.state.setParamConfig(null);
            }
        });
        this.parser.addNodelet("/sqlMap/parameterMap", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                String id = SqlMapParser.this.state.applyNamespace(attributes.getProperty("id"));
                String parameterClassName = attributes.getProperty("class");
                parameterClassName = SqlMapParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(parameterClassName);
                try {
                    SqlMapParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the parameter class.");
                    ParameterMapConfig paramConf = SqlMapParser.this.state.getConfig().newParameterMapConfig(id, Resources.classForName(parameterClassName));
                    SqlMapParser.this.state.setParamConfig(paramConf);
                }
                catch (Exception e) {
                    throw new SqlMapException("Error configuring ParameterMap.  Could not set ParameterClass.  Cause: " + String.valueOf(e), e);
                }
            }
        });
        this.parser.addNodelet("/sqlMap/parameterMap/parameter", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties childAttributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                String propertyName = childAttributes.getProperty("property");
                String jdbcType = childAttributes.getProperty("jdbcType");
                String type = childAttributes.getProperty("typeName");
                String javaType = childAttributes.getProperty("javaType");
                String resultMap = SqlMapParser.this.state.applyNamespace(childAttributes.getProperty("resultMap"));
                String nullValue = childAttributes.getProperty("nullValue");
                String mode = childAttributes.getProperty("mode");
                String callback = childAttributes.getProperty("typeHandler");
                String numericScaleProp = childAttributes.getProperty("numericScale");
                callback = SqlMapParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(callback);
                Object typeHandlerImpl = null;
                if (callback != null) {
                    typeHandlerImpl = Resources.instantiate(callback);
                }
                javaType = SqlMapParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(javaType);
                Class javaClass = null;
                try {
                    if (javaType != null && javaType.length() > 0) {
                        javaClass = Resources.classForName(javaType);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error setting javaType on parameter mapping.  Cause: " + String.valueOf(e));
                }
                Integer numericScale = null;
                if (numericScaleProp != null) {
                    numericScale = Integer.valueOf(numericScaleProp);
                }
                SqlMapParser.this.state.getParamConfig().addParameterMapping(propertyName, javaClass, jdbcType, nullValue, mode, type, numericScale, typeHandlerImpl, resultMap);
            }
        });
    }

    private void addResultMapNodelets() {
        this.parser.addNodelet("/sqlMap/resultMap/end()", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapParser.this.state.getConfig().getErrorContext().setMoreInfo(null);
                SqlMapParser.this.state.getConfig().getErrorContext().setObjectId(null);
            }
        });
        this.parser.addNodelet("/sqlMap/resultMap", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Class resultClass;
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                String id = SqlMapParser.this.state.applyNamespace(attributes.getProperty("id"));
                String resultClassName = attributes.getProperty("class");
                String extended = SqlMapParser.this.state.applyNamespace(attributes.getProperty("extends"));
                String xmlName = attributes.getProperty("xmlName");
                String groupBy = attributes.getProperty("groupBy");
                resultClassName = SqlMapParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(resultClassName);
                try {
                    SqlMapParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the result class.");
                    resultClass = Resources.classForName(resultClassName);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error configuring Result.  Could not set ResultClass.  Cause: " + String.valueOf(e), e);
                }
                ResultMapConfig resultConf = SqlMapParser.this.state.getConfig().newResultMapConfig(id, resultClass, groupBy, extended, xmlName);
                SqlMapParser.this.state.setResultConfig(resultConf);
            }
        });
        this.parser.addNodelet("/sqlMap/resultMap/result", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties childAttributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                String propertyName = childAttributes.getProperty("property");
                String nullValue = childAttributes.getProperty("nullValue");
                String jdbcType = childAttributes.getProperty("jdbcType");
                String javaType = childAttributes.getProperty("javaType");
                String columnName = childAttributes.getProperty("column");
                String columnIndexProp = childAttributes.getProperty("columnIndex");
                String statementName = childAttributes.getProperty("select");
                String resultMapName = childAttributes.getProperty("resultMap");
                String callback = childAttributes.getProperty("typeHandler");
                String notNullColumn = childAttributes.getProperty("notNullColumn");
                SqlMapParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the result mapping property type or name.");
                Class javaClass = null;
                try {
                    javaType = SqlMapParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(javaType);
                    if (javaType != null && javaType.length() > 0) {
                        javaClass = Resources.classForName(javaType);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error setting java type on result discriminator mapping.  Cause: " + String.valueOf(e));
                }
                SqlMapParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the result mapping typeHandler attribute '" + callback + "' (must be a TypeHandler or TypeHandlerCallback implementation).");
                Object typeHandlerImpl = null;
                try {
                    if (callback != null && callback.length() > 0) {
                        callback = SqlMapParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(callback);
                        typeHandlerImpl = Resources.instantiate(callback);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error occurred during custom type handler configuration.  Cause: " + String.valueOf(e), e);
                }
                Integer columnIndex = null;
                if (columnIndexProp != null) {
                    try {
                        columnIndex = Integer.valueOf(columnIndexProp);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error parsing column index.  Cause: " + String.valueOf(e), e);
                    }
                }
                SqlMapParser.this.state.getResultConfig().addResultMapping(propertyName, columnName, columnIndex, javaClass, jdbcType, nullValue, notNullColumn, statementName, resultMapName, typeHandlerImpl);
            }
        });
        this.parser.addNodelet("/sqlMap/resultMap/discriminator/subMap", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties childAttributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                String value = childAttributes.getProperty("value");
                String resultMap = childAttributes.getProperty("resultMap");
                resultMap = SqlMapParser.this.state.applyNamespace(resultMap);
                SqlMapParser.this.state.getResultConfig().addDiscriminatorSubMap(value, resultMap);
            }
        });
        this.parser.addNodelet("/sqlMap/resultMap/discriminator", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                Properties childAttributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.state.getGlobalProps());
                String nullValue = childAttributes.getProperty("nullValue");
                String jdbcType = childAttributes.getProperty("jdbcType");
                String javaType = childAttributes.getProperty("javaType");
                String columnName = childAttributes.getProperty("column");
                String columnIndexProp = childAttributes.getProperty("columnIndex");
                String callback = childAttributes.getProperty("typeHandler");
                SqlMapParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the disriminator type or name.");
                Class javaClass = null;
                try {
                    javaType = SqlMapParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(javaType);
                    if (javaType != null && javaType.length() > 0) {
                        javaClass = Resources.classForName(javaType);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error setting java type on result discriminator mapping.  Cause: " + String.valueOf(e));
                }
                SqlMapParser.this.state.getConfig().getErrorContext().setMoreInfo("Check the result mapping discriminator typeHandler attribute '" + callback + "' (must be a TypeHandlerCallback implementation).");
                Object typeHandlerImpl = null;
                try {
                    if (callback != null && callback.length() > 0) {
                        callback = SqlMapParser.this.state.getConfig().getTypeHandlerFactory().resolveAlias(callback);
                        typeHandlerImpl = Resources.instantiate(callback);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error occurred during custom type handler configuration.  Cause: " + String.valueOf(e), e);
                }
                Integer columnIndex = null;
                if (columnIndexProp != null) {
                    try {
                        columnIndex = Integer.valueOf(columnIndexProp);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error parsing column index.  Cause: " + String.valueOf(e), e);
                    }
                }
                SqlMapParser.this.state.getResultConfig().setDiscriminator(columnName, columnIndex, javaClass, jdbcType, nullValue, typeHandlerImpl);
            }
        });
    }

    protected void addStatementNodelets() {
        this.parser.addNodelet("/sqlMap/statement", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapParser.this.statementParser.parseGeneralStatement(node, new MappedStatement());
            }
        });
        this.parser.addNodelet("/sqlMap/insert", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapParser.this.statementParser.parseGeneralStatement(node, new InsertStatement());
            }
        });
        this.parser.addNodelet("/sqlMap/update", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapParser.this.statementParser.parseGeneralStatement(node, new UpdateStatement());
            }
        });
        this.parser.addNodelet("/sqlMap/delete", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapParser.this.statementParser.parseGeneralStatement(node, new DeleteStatement());
            }
        });
        this.parser.addNodelet("/sqlMap/select", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapParser.this.statementParser.parseGeneralStatement(node, new SelectStatement());
            }
        });
        this.parser.addNodelet("/sqlMap/procedure", new Nodelet(){

            @Override
            public void process(Node node) throws Exception {
                SqlMapParser.this.statementParser.parseGeneralStatement(node, new ProcedureStatement());
            }
        });
    }
}

