/*
 * Copyright 2004-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibatis.sqlmap.engine.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * String implementation of TypeHandler.
 */
public class EnumTypeHandler extends BaseTypeHandler implements TypeHandler {

  /** The type. */
  private Class type;

  /**
   * Instantiates a new enum type handler.
   *
   * @param type
   *          the type
   */
  public EnumTypeHandler(Class type) {
    this.type = type;
  }

  public void setParameter(PreparedStatement ps, int i, Object parameter, String jdbcType) throws SQLException {
    ps.setString(i, parameter.toString());
  }

  public Object getResult(ResultSet rs, String columnName) throws SQLException {
    Object s = rs.getString(columnName);
    if (rs.wasNull()) {
      return null;
    } else {
      return Enum.valueOf(type, (String) s);
    }
  }

  public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
    Object s = rs.getString(columnIndex);
    if (rs.wasNull()) {
      return null;
    } else {
      return Enum.valueOf(type, (String) s);
    }
  }

  public Object getResult(CallableStatement cs, int columnIndex) throws SQLException {
    Object s = cs.getString(columnIndex);
    if (cs.wasNull()) {
      return null;
    } else {
      return Enum.valueOf(type, (String) s);
    }
  }

  public Object valueOf(String s) {
    return Enum.valueOf(type, (String) s);
  }

}
