/*
 * Copyright 2004-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.sqlmap.client.event.RowHandler;

import java.util.ArrayList;
import java.util.List;

/**
 * The Class DefaultRowHandler.
 */
public class DefaultRowHandler implements RowHandler {

  /** The list. */
  private List list = new ArrayList();

  public void handleRow(Object valueObject) {
    list.add(valueObject);
  }

  /**
   * Gets the list.
   *
   * @return the list
   */
  public List getList() {
    return list;
  }

  /**
   * Sets the list.
   *
   * @param list
   *          the new list
   */
  public void setList(List list) {
    this.list = list;
  }

}
