/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.type;

import com.ibatis.sqlmap.engine.type.BaseTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UnknownTypeHandler
extends BaseTypeHandler
implements TypeHandler {
    private TypeHandlerFactory factory;

    public UnknownTypeHandler(TypeHandlerFactory factory) {
        this.factory = factory;
    }

    @Override
    public void setParameter(PreparedStatement ps, int i, Object parameter, String jdbcType) throws SQLException {
        Class<?> searchClass = parameter.getClass();
        if (searchClass == null) {
            searchClass = parameter.getClass();
        }
        TypeHandler handler = this.factory.getTypeHandler(searchClass, jdbcType);
        handler.setParameter(ps, i, parameter, jdbcType);
    }

    @Override
    public Object getResult(ResultSet rs, String columnName) throws SQLException {
        Object object = rs.getObject(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return object;
    }

    @Override
    public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
        Object object = rs.getObject(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return object;
    }

    @Override
    public Object getResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object object = cs.getObject(columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return object;
    }

    @Override
    public Object valueOf(String s) {
        return s;
    }

    @Override
    public boolean equals(Object object, String string) {
        if (object == null || string == null) {
            return object == string;
        }
        TypeHandler handler = this.factory.getTypeHandler(object.getClass());
        Object castedObject = handler.valueOf(string);
        return object.equals(castedObject);
    }
}

