/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.type;

import com.ibatis.sqlmap.engine.type.BaseTypeHandler;
import com.ibatis.sqlmap.engine.type.SimpleDateFormatter;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SqlDateTypeHandler
extends BaseTypeHandler
implements TypeHandler {
    private static final String DATE_FORMAT = "yyyy/MM/dd";

    @Override
    public void setParameter(PreparedStatement ps, int i, Object parameter, String jdbcType) throws SQLException {
        ps.setDate(i, (Date)parameter);
    }

    @Override
    public Object getResult(ResultSet rs, String columnName) throws SQLException {
        Date sqlDate = rs.getDate(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return sqlDate;
    }

    @Override
    public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
        Date sqlDate = rs.getDate(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return sqlDate;
    }

    @Override
    public Object getResult(CallableStatement cs, int columnIndex) throws SQLException {
        Date sqlDate = cs.getDate(columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return sqlDate;
    }

    @Override
    public Object valueOf(String s) {
        return SimpleDateFormatter.format(DATE_FORMAT, s);
    }
}

