/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.BaseTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IterateContext;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagContext;
import com.ibatis.sqlmap.engine.type.SimpleDateFormatter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public abstract class ConditionalTagHandler
extends BaseTagHandler {
    private static final Probe PROBE = ProbeFactory.getProbe();
    public static final long NOT_COMPARABLE = Long.MIN_VALUE;
    private static final String DATE_MASK = "yyyy/MM/dd hh:mm:ss";
    private static final String START_INDEX = "[";

    public abstract boolean isCondition(SqlTagContext var1, SqlTag var2, Object var3);

    @Override
    public int doStartFragment(SqlTagContext ctx, SqlTag tag, Object parameterObject) {
        ctx.pushRemoveFirstPrependMarker(tag);
        if (this.isCondition(ctx, tag, parameterObject)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int doEndFragment(SqlTagContext ctx, SqlTag tag, Object parameterObject, StringBuilder bodyContent) {
        IterateContext iterate = ctx.peekIterateContext();
        if (null != iterate && iterate.isAllowNext()) {
            iterate.next();
            iterate.setAllowNext(false);
            if (!iterate.hasNext()) {
                iterate.setFinal(true);
            }
        }
        return super.doEndFragment(ctx, tag, parameterObject, bodyContent);
    }

    protected long compare(SqlTagContext ctx, SqlTag tag, Object parameterObject) {
        Class<Object> type;
        Object value1;
        String comparePropertyName = tag.getComparePropertyAttr();
        String compareValue = tag.getCompareValueAttr();
        String prop = this.getResolvedProperty(ctx, tag);
        if (prop != null) {
            value1 = PROBE.getObject(parameterObject, prop);
            type = PROBE.getPropertyTypeForGetter(parameterObject, prop);
        } else {
            value1 = parameterObject;
            type = value1 != null ? parameterObject.getClass() : Object.class;
        }
        if (comparePropertyName != null) {
            Object value2 = PROBE.getObject(parameterObject, comparePropertyName);
            return this.compareValues(type, value1, value2);
        }
        if (compareValue != null) {
            return this.compareValues(type, value1, compareValue);
        }
        throw new RuntimeException("Error comparing in conditional fragment.  Uknown 'compare to' values.");
    }

    protected long compareValues(Class type, Object value1, Object value2) {
        long result = Long.MIN_VALUE;
        if (value1 == null || value2 == null) {
            result = value1 == value2 ? 0L : Long.MIN_VALUE;
        } else {
            if (value2.getClass() != type) {
                value2 = this.convertValue(type, value2.toString());
            }
            if (value2 instanceof String && type != String.class) {
                value1 = value1.toString();
            }
            if (!(value1 instanceof Comparable) || !(value2 instanceof Comparable)) {
                value1 = value1.toString();
                value2 = value2.toString();
            }
            result = ((Comparable)value1).compareTo(value2);
        }
        return result;
    }

    protected Object convertValue(Class type, String value) {
        if (type == String.class) {
            return value;
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return Byte.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return Short.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return Character.valueOf(value.charAt(0));
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.valueOf(value);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Boolean.valueOf(value);
        }
        if (type == Date.class) {
            return SimpleDateFormatter.format(DATE_MASK, value);
        }
        if (type == BigInteger.class) {
            return new BigInteger(value);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value);
        }
        return value;
    }

    protected String getResolvedProperty(SqlTagContext ctx, SqlTag tag) {
        String prop = tag.getPropertyAttr();
        IterateContext itCtx = ctx.peekIterateContext();
        if (prop != null) {
            if (null != itCtx && itCtx.isAllowNext()) {
                itCtx.next();
                itCtx.setAllowNext(false);
                if (!itCtx.hasNext()) {
                    itCtx.setFinal(true);
                }
            }
            if (prop.indexOf(START_INDEX) > -1 && itCtx != null) {
                prop = itCtx.addIndexToTagProperty(prop);
            }
        }
        return prop;
    }
}

