/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.datasource;

import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.datasource.DataSourceFactory;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JndiDataSourceFactory
implements DataSourceFactory {
    private DataSource dataSource;

    @Override
    public void initialize(Map properties) {
        try {
            InitialContext initCtx = null;
            Hashtable context = JndiDataSourceFactory.getContextProperties(properties);
            initCtx = context == null ? new InitialContext() : new InitialContext(context);
            if (properties.containsKey("DataSource")) {
                this.dataSource = (DataSource)initCtx.lookup((String)properties.get("DataSource"));
            } else if (properties.containsKey("DBJndiContext")) {
                this.dataSource = (DataSource)initCtx.lookup((String)properties.get("DBJndiContext"));
            } else if (properties.containsKey("DBFullJndiContext")) {
                this.dataSource = (DataSource)initCtx.lookup((String)properties.get("DBFullJndiContext"));
            } else if (properties.containsKey("DBInitialContext") && properties.containsKey("DBLookup")) {
                Context ctx = (Context)initCtx.lookup((String)properties.get("DBInitialContext"));
                this.dataSource = (DataSource)ctx.lookup((String)properties.get("DBLookup"));
            }
        }
        catch (NamingException e) {
            throw new SqlMapException("There was an error configuring JndiDataSourceTransactionPool. Cause: " + String.valueOf(e), e);
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    private static Hashtable getContextProperties(Map allProps) {
        String PREFIX = "context.";
        Properties contextProperties = null;
        for (String key : allProps.keySet()) {
            String value = (String)allProps.get(key);
            if (!key.startsWith("context.")) continue;
            if (contextProperties == null) {
                contextProperties = new Properties();
            }
            ((Hashtable)contextProperties).put(key.substring("context.".length()), value);
        }
        return contextProperties;
    }
}

