/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.config;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;
import com.ibatis.sqlmap.engine.accessplan.AccessPlanFactory;
import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.cache.fifo.FifoCacheController;
import com.ibatis.sqlmap.engine.cache.lru.LruCacheController;
import com.ibatis.sqlmap.engine.cache.memory.MemoryCacheController;
import com.ibatis.sqlmap.engine.config.CacheModelConfig;
import com.ibatis.sqlmap.engine.config.MappedStatementConfig;
import com.ibatis.sqlmap.engine.config.ParameterMapConfig;
import com.ibatis.sqlmap.engine.config.ResultMapConfig;
import com.ibatis.sqlmap.engine.config.SqlSource;
import com.ibatis.sqlmap.engine.datasource.DbcpDataSourceFactory;
import com.ibatis.sqlmap.engine.datasource.JndiDataSourceFactory;
import com.ibatis.sqlmap.engine.datasource.SimpleDataSourceFactory;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.result.Discriminator;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactory;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import com.ibatis.sqlmap.engine.transaction.external.ExternalTransactionConfig;
import com.ibatis.sqlmap.engine.transaction.jdbc.JdbcTransactionConfig;
import com.ibatis.sqlmap.engine.transaction.jta.JtaTransactionConfig;
import com.ibatis.sqlmap.engine.type.CustomTypeHandler;
import com.ibatis.sqlmap.engine.type.DomCollectionTypeMarker;
import com.ibatis.sqlmap.engine.type.DomTypeMarker;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import com.ibatis.sqlmap.engine.type.XmlCollectionTypeMarker;
import com.ibatis.sqlmap.engine.type.XmlTypeMarker;
import java.util.Iterator;
import java.util.Map;

public class SqlMapConfiguration {
    private static final Probe PROBE = ProbeFactory.getProbe();
    private ErrorContext errorContext = new ErrorContext();
    private SqlMapExecutorDelegate delegate = new SqlMapExecutorDelegate();
    private TypeHandlerFactory typeHandlerFactory = this.delegate.getTypeHandlerFactory();
    private SqlMapClientImpl client = new SqlMapClientImpl(this.delegate);
    private Integer defaultStatementTimeout;

    public SqlMapConfiguration() {
        this.registerDefaultTypeAliases();
    }

    public TypeHandlerFactory getTypeHandlerFactory() {
        return this.typeHandlerFactory;
    }

    public ErrorContext getErrorContext() {
        return this.errorContext;
    }

    public SqlMapClientImpl getClient() {
        return this.client;
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    public void setClassInfoCacheEnabled(boolean classInfoCacheEnabled) {
        this.errorContext.setActivity("setting class info cache enabled/disabled");
        ClassInfo.setCacheEnabled(classInfoCacheEnabled);
    }

    public void setLazyLoadingEnabled(boolean lazyLoadingEnabled) {
        this.errorContext.setActivity("setting lazy loading enabled/disabled");
        this.client.getDelegate().setLazyLoadingEnabled(lazyLoadingEnabled);
    }

    public void setStatementCachingEnabled(boolean statementCachingEnabled) {
        this.errorContext.setActivity("setting statement caching enabled/disabled");
        this.client.getDelegate().setStatementCacheEnabled(statementCachingEnabled);
    }

    public void setCacheModelsEnabled(boolean cacheModelsEnabled) {
        this.errorContext.setActivity("setting cache models enabled/disabled");
        this.client.getDelegate().setCacheModelsEnabled(cacheModelsEnabled);
    }

    public void setEnhancementEnabled(boolean enhancementEnabled) {
        this.errorContext.setActivity("setting enhancement enabled/disabled");
        try {
            enhancementEnabled = enhancementEnabled && Resources.classForName("net.sf.cglib.proxy.InvocationHandler") != null;
        }
        catch (ClassNotFoundException e) {
            enhancementEnabled = false;
        }
        this.client.getDelegate().setEnhancementEnabled(enhancementEnabled);
        AccessPlanFactory.setBytecodeEnhancementEnabled(enhancementEnabled);
    }

    public void setUseColumnLabel(boolean useColumnLabel) {
        this.client.getDelegate().setUseColumnLabel(useColumnLabel);
    }

    public void setForceMultipleResultSetSupport(boolean forceMultipleResultSetSupport) {
        this.client.getDelegate().setForceMultipleResultSetSupport(forceMultipleResultSetSupport);
    }

    public void setDefaultStatementTimeout(Integer defaultTimeout) {
        this.errorContext.setActivity("setting default timeout");
        if (defaultTimeout != null) {
            try {
                this.defaultStatementTimeout = defaultTimeout;
            }
            catch (NumberFormatException e) {
                throw new SqlMapException("Specified defaultStatementTimeout is not a valid integer");
            }
        }
    }

    public void setTransactionManager(TransactionManager txManager) {
        this.delegate.setTxManager(txManager);
    }

    public void setResultObjectFactory(ResultObjectFactory rof) {
        this.delegate.setResultObjectFactory(rof);
    }

    public void newTypeHandler(Class javaType, String jdbcType, Object callback) {
        try {
            TypeHandler typeHandler;
            this.errorContext.setActivity("building a building custom type handler");
            TypeHandlerFactory typeHandlerFactory = this.client.getDelegate().getTypeHandlerFactory();
            if (callback instanceof TypeHandlerCallback) {
                typeHandler = new CustomTypeHandler((TypeHandlerCallback)callback);
            } else if (callback instanceof TypeHandler) {
                typeHandler = (TypeHandler)callback;
            } else {
                throw new RuntimeException("The object '" + String.valueOf(callback) + "' is not a valid implementation of TypeHandler or TypeHandlerCallback");
            }
            this.errorContext.setMoreInfo("Check the javaType attribute '" + String.valueOf(javaType) + "' (must be a classname) or the jdbcType '" + jdbcType + "' (must be a JDBC type name).");
            if (jdbcType != null && jdbcType.length() > 0) {
                typeHandlerFactory.register(javaType, jdbcType, typeHandler);
            } else {
                typeHandlerFactory.register(javaType, typeHandler);
            }
        }
        catch (Exception e) {
            throw new SqlMapException("Error registering occurred.  Cause: " + String.valueOf(e), e);
        }
        this.errorContext.setMoreInfo(null);
        this.errorContext.setObjectId(null);
    }

    public CacheModelConfig newCacheModelConfig(String id, CacheController controller, boolean readOnly, boolean serialize) {
        return new CacheModelConfig(this, id, controller, readOnly, serialize);
    }

    public ParameterMapConfig newParameterMapConfig(String id, Class parameterClass) {
        return new ParameterMapConfig(this, id, parameterClass);
    }

    public ResultMapConfig newResultMapConfig(String id, Class resultClass, String groupBy, String extended, String xmlName) {
        return new ResultMapConfig(this, id, resultClass, groupBy, extended, xmlName);
    }

    public MappedStatementConfig newMappedStatementConfig(String id, MappedStatement statement, SqlSource processor, String parameterMapName, Class parameterClass, String resultMapName, String[] additionalResultMapNames, Class resultClass, Class[] additionalResultClasses, String resultSetType, Integer fetchSize, boolean allowRemapping, Integer timeout, String cacheModelName, String xmlResultName) {
        return new MappedStatementConfig(this, id, statement, processor, parameterMapName, parameterClass, resultMapName, additionalResultMapNames, resultClass, additionalResultClasses, cacheModelName, resultSetType, fetchSize, allowRemapping, timeout, this.defaultStatementTimeout, xmlResultName);
    }

    public void finalizeSqlMapConfig() {
        this.wireUpCacheModels();
        this.bindResultMapDiscriminators();
    }

    TypeHandler resolveTypeHandler(TypeHandlerFactory typeHandlerFactory, Class clazz, String propertyName, Class javaType, String jdbcType) {
        return this.resolveTypeHandler(typeHandlerFactory, clazz, propertyName, javaType, jdbcType, false);
    }

    TypeHandler resolveTypeHandler(TypeHandlerFactory typeHandlerFactory, Class clazz, String propertyName, Class javaType, String jdbcType, boolean useSetterToResolve) {
        TypeHandler handler;
        if (clazz == null) {
            handler = typeHandlerFactory.getUnkownTypeHandler();
        } else if (DomTypeMarker.class.isAssignableFrom(clazz)) {
            handler = typeHandlerFactory.getTypeHandler(String.class, jdbcType);
        } else if (Map.class.isAssignableFrom(clazz)) {
            handler = javaType == null ? typeHandlerFactory.getUnkownTypeHandler() : typeHandlerFactory.getTypeHandler(javaType, jdbcType);
        } else if (typeHandlerFactory.getTypeHandler(clazz, jdbcType) != null) {
            handler = typeHandlerFactory.getTypeHandler(clazz, jdbcType);
        } else if (javaType == null) {
            if (useSetterToResolve) {
                Class type = PROBE.getPropertyTypeForSetter(clazz, propertyName);
                handler = typeHandlerFactory.getTypeHandler(type, jdbcType);
            } else {
                Class type = PROBE.getPropertyTypeForGetter(clazz, propertyName);
                handler = typeHandlerFactory.getTypeHandler(type, jdbcType);
            }
        } else {
            handler = typeHandlerFactory.getTypeHandler(javaType, jdbcType);
        }
        return handler;
    }

    private void registerDefaultTypeAliases() {
        this.typeHandlerFactory.putTypeAlias("JDBC", JdbcTransactionConfig.class.getName());
        this.typeHandlerFactory.putTypeAlias("JTA", JtaTransactionConfig.class.getName());
        this.typeHandlerFactory.putTypeAlias("EXTERNAL", ExternalTransactionConfig.class.getName());
        this.typeHandlerFactory.putTypeAlias("SIMPLE", SimpleDataSourceFactory.class.getName());
        this.typeHandlerFactory.putTypeAlias("DBCP", DbcpDataSourceFactory.class.getName());
        this.typeHandlerFactory.putTypeAlias("JNDI", JndiDataSourceFactory.class.getName());
        this.typeHandlerFactory.putTypeAlias("FIFO", FifoCacheController.class.getName());
        this.typeHandlerFactory.putTypeAlias("LRU", LruCacheController.class.getName());
        this.typeHandlerFactory.putTypeAlias("MEMORY", MemoryCacheController.class.getName());
        this.typeHandlerFactory.putTypeAlias("dom", DomTypeMarker.class.getName());
        this.typeHandlerFactory.putTypeAlias("domCollection", DomCollectionTypeMarker.class.getName());
        this.typeHandlerFactory.putTypeAlias("xml", XmlTypeMarker.class.getName());
        this.typeHandlerFactory.putTypeAlias("xmlCollection", XmlCollectionTypeMarker.class.getName());
    }

    private void wireUpCacheModels() {
        Iterator cacheNames = this.client.getDelegate().getCacheModelNames();
        while (cacheNames.hasNext()) {
            String cacheName = (String)cacheNames.next();
            CacheModel cacheModel = this.client.getDelegate().getCacheModel(cacheName);
            Iterator statementNames = cacheModel.getFlushTriggerStatementNames();
            while (statementNames.hasNext()) {
                String statementName = (String)statementNames.next();
                MappedStatement statement = this.client.getDelegate().getMappedStatement(statementName);
                if (statement != null) {
                    statement.addExecuteListener(cacheModel);
                    continue;
                }
                throw new RuntimeException("Could not find statement named '" + statementName + "' for use as a flush trigger for the cache model named '" + cacheName + "'.");
            }
        }
    }

    private void bindResultMapDiscriminators() {
        Iterator names = this.delegate.getResultMapNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            ResultMap rm = this.delegate.getResultMap(name);
            Discriminator disc = rm.getDiscriminator();
            if (disc == null) continue;
            disc.bindSubMaps();
        }
    }
}

