/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.xml;

import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NodeletUtils {
    public static boolean getBooleanAttribute(Properties attribs, String name, boolean def) {
        String value = attribs.getProperty(name);
        if (value == null) {
            return def;
        }
        return "true".equals(value);
    }

    public static int getIntAttribute(Properties attribs, String name, int def) {
        String value = attribs.getProperty(name);
        if (value == null) {
            return def;
        }
        return Integer.parseInt(value);
    }

    public static Properties parseAttributes(Node n) {
        return NodeletUtils.parseAttributes(n, null);
    }

    public static Properties parseAttributes(Node n, Properties variables) {
        Properties attributes = new Properties();
        NamedNodeMap attributeNodes = n.getAttributes();
        for (int i = 0; i < attributeNodes.getLength(); ++i) {
            Node attribute = attributeNodes.item(i);
            String value = NodeletUtils.parsePropertyTokens(attribute.getNodeValue(), variables);
            attributes.put(attribute.getNodeName(), value);
        }
        return attributes;
    }

    public static String parsePropertyTokens(String string, Properties variables) {
        String OPEN = "${";
        String CLOSE = "}";
        Object newString = string;
        if (newString != null && variables != null) {
            int start = ((String)newString).indexOf("${");
            int end = ((String)newString).indexOf("}");
            while (start > -1 && end > start) {
                String prepend = ((String)newString).substring(0, start);
                String append = ((String)newString).substring(end + "}".length());
                String propName = ((String)newString).substring(start + "${".length(), end);
                String propValue = variables.getProperty(propName);
                newString = propValue == null ? prepend + propName + append : prepend + propValue + append;
                start = ((String)newString).indexOf("${");
                end = ((String)newString).indexOf("}");
            }
        }
        return newString;
    }
}

