/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.impl;

import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.impl.SqlMapSessionImpl;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactory;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class SqlMapClientImpl
implements SqlMapClient,
ExtendedSqlMapClient {
    private static final Log log = LogFactory.getLog(SqlMapClientImpl.class);
    public SqlMapExecutorDelegate delegate;
    protected ThreadLocal<SqlMapSessionImpl> localSqlMapSession = new ThreadLocal();

    public SqlMapClientImpl(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object insert(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSession().insert(id, param);
    }

    @Override
    public Object insert(String id) throws SQLException {
        return this.getLocalSqlMapSession().insert(id);
    }

    @Override
    public int update(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSession().update(id, param);
    }

    @Override
    public int update(String id) throws SQLException {
        return this.getLocalSqlMapSession().update(id);
    }

    @Override
    public int delete(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSession().delete(id, param);
    }

    @Override
    public int delete(String id) throws SQLException {
        return this.getLocalSqlMapSession().delete(id);
    }

    @Override
    public Object queryForObject(String id, Object paramObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForObject(id, paramObject);
    }

    @Override
    public Object queryForObject(String id) throws SQLException {
        return this.getLocalSqlMapSession().queryForObject(id);
    }

    @Override
    public Object queryForObject(String id, Object paramObject, Object resultObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForObject(id, paramObject, resultObject);
    }

    @Override
    public List queryForList(String id, Object paramObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id, paramObject);
    }

    @Override
    public List queryForList(String id) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id);
    }

    @Override
    public List queryForList(String id, Object paramObject, int skip, int max) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id, paramObject, skip, max);
    }

    @Override
    public List queryForList(String id, int skip, int max) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id, skip, max);
    }

    @Override
    public PaginatedList queryForPaginatedList(String id, Object paramObject, int pageSize) throws SQLException {
        return this.getLocalSqlMapSession().queryForPaginatedList(id, paramObject, pageSize);
    }

    @Override
    public PaginatedList queryForPaginatedList(String id, int pageSize) throws SQLException {
        return this.getLocalSqlMapSession().queryForPaginatedList(id, pageSize);
    }

    @Override
    public Map queryForMap(String id, Object paramObject, String keyProp) throws SQLException {
        return this.getLocalSqlMapSession().queryForMap(id, paramObject, keyProp);
    }

    @Override
    public Map queryForMap(String id, Object paramObject, String keyProp, String valueProp) throws SQLException {
        return this.getLocalSqlMapSession().queryForMap(id, paramObject, keyProp, valueProp);
    }

    @Override
    public void queryWithRowHandler(String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        this.getLocalSqlMapSession().queryWithRowHandler(id, paramObject, rowHandler);
    }

    @Override
    public void queryWithRowHandler(String id, RowHandler rowHandler) throws SQLException {
        this.getLocalSqlMapSession().queryWithRowHandler(id, rowHandler);
    }

    @Override
    public void startTransaction() throws SQLException {
        this.getLocalSqlMapSession().startTransaction();
    }

    @Override
    public void startTransaction(int transactionIsolation) throws SQLException {
        this.getLocalSqlMapSession().startTransaction(transactionIsolation);
    }

    @Override
    public void commitTransaction() throws SQLException {
        this.getLocalSqlMapSession().commitTransaction();
    }

    @Override
    public void endTransaction() throws SQLException {
        try {
            this.getLocalSqlMapSession().endTransaction();
        }
        finally {
            this.getLocalSqlMapSession().close();
            this.localSqlMapSession.remove();
        }
    }

    @Override
    public void startBatch() throws SQLException {
        this.getLocalSqlMapSession().startBatch();
    }

    @Override
    public int executeBatch() throws SQLException {
        return this.getLocalSqlMapSession().executeBatch();
    }

    @Override
    public List executeBatchDetailed() throws SQLException, BatchException {
        return this.getLocalSqlMapSession().executeBatchDetailed();
    }

    @Override
    public void setUserConnection(Connection connection) throws SQLException {
        try {
            this.getLocalSqlMapSession().setUserConnection(connection);
        }
        finally {
            if (connection == null) {
                this.getLocalSqlMapSession().close();
            }
        }
    }

    @Override
    public Connection getUserConnection() throws SQLException {
        return this.getCurrentConnection();
    }

    @Override
    public Connection getCurrentConnection() throws SQLException {
        return this.getLocalSqlMapSession().getCurrentConnection();
    }

    @Override
    public DataSource getDataSource() {
        return this.delegate.getDataSource();
    }

    @Override
    public MappedStatement getMappedStatement(String id) {
        return this.delegate.getMappedStatement(id);
    }

    @Override
    public boolean isLazyLoadingEnabled() {
        return this.delegate.isLazyLoadingEnabled();
    }

    @Override
    public boolean isEnhancementEnabled() {
        return this.delegate.isEnhancementEnabled();
    }

    @Override
    public SqlExecutor getSqlExecutor() {
        return this.delegate.getSqlExecutor();
    }

    @Override
    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public SqlMapSession openSession() {
        SqlMapSessionImpl sqlMapSession = new SqlMapSessionImpl(this);
        sqlMapSession.open();
        return sqlMapSession;
    }

    @Override
    public SqlMapSession openSession(Connection conn) {
        try {
            SqlMapSessionImpl sqlMapSession = new SqlMapSessionImpl(this);
            sqlMapSession.open();
            sqlMapSession.setUserConnection(conn);
            return sqlMapSession;
        }
        catch (SQLException e) {
            throw new SqlMapException("Error setting user provided connection.  Cause: " + e, e);
        }
    }

    @Override
    public SqlMapSession getSession() {
        log.warn("Use of a deprecated API detected.  SqlMapClient.getSession() is deprecated.  Use SqlMapClient.openSession() instead.");
        return this.openSession();
    }

    @Override
    public void flushDataCache() {
        this.delegate.flushDataCache();
    }

    @Override
    public void flushDataCache(String cacheId) {
        this.delegate.flushDataCache(cacheId);
    }

    protected SqlMapSessionImpl getLocalSqlMapSession() {
        SqlMapSessionImpl sqlMapSession = this.localSqlMapSession.get();
        if (sqlMapSession == null || sqlMapSession.isClosed()) {
            sqlMapSession = new SqlMapSessionImpl(this);
            this.localSqlMapSession.set(sqlMapSession);
        }
        return sqlMapSession;
    }

    @Override
    public ResultObjectFactory getResultObjectFactory() {
        return this.delegate.getResultObjectFactory();
    }
}

