/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.oscache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ibatis.cache.Cache;

public final class OSCache
implements Cache {
    private static final GeneralCacheAdministrator CACHE_ADMINISTRATOR = new GeneralCacheAdministrator();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final String id;

    public OSCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
    }

    public void clear() {
        CACHE_ADMINISTRATOR.flushGroup(this.id);
    }

    public String getId() {
        return this.id;
    }

    public Object getObject(Object key) {
        String keyString = key.toString();
        Object ret = null;
        try {
            ret = CACHE_ADMINISTRATOR.getFromCache(keyString);
        }
        catch (NeedsRefreshException e) {
            CACHE_ADMINISTRATOR.cancelUpdate(keyString);
        }
        return ret;
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public int getSize() {
        return CACHE_ADMINISTRATOR.getCache().getSize();
    }

    public void putObject(Object key, Object value) {
        CACHE_ADMINISTRATOR.putInCache(key.toString(), value, new String[]{this.id});
    }

    public Object removeObject(Object key) {
        String keyString = key.toString();
        Object ret = null;
        try {
            ret = CACHE_ADMINISTRATOR.getFromCache(keyString);
        }
        catch (NeedsRefreshException e) {
            CACHE_ADMINISTRATOR.cancelUpdate(keyString);
        }
        if (ret != null) {
            CACHE_ADMINISTRATOR.flushEntry(keyString);
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cache)) {
            return false;
        }
        Cache otherCache = (Cache)obj;
        return this.id.equals(otherCache.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "OSCache {" + this.id + "}";
    }
}

