/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.templates.res;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.templates.TemplateError;
import org.mvel2.templates.TemplateRuntime;
import org.mvel2.templates.res.Node;
import org.mvel2.templates.util.TemplateOutputStream;
import org.mvel2.templates.util.TemplateTools;
import org.mvel2.util.ParseTools;

public class IncludeNode
extends Node {
    private char[] includeExpression;
    private char[] preExpression;

    public IncludeNode(int begin, String name, char[] template, int start, int end) {
        this.begin = begin;
        this.name = name;
        this.cStart = start;
        this.end = this.cEnd = end;
        this.contents = ParseTools.subset(template, this.cStart, this.cEnd - start - 1);
        int mark = TemplateTools.captureToEOS(this.contents, 0);
        this.includeExpression = ParseTools.subset(this.contents, 0, mark);
        if (mark != this.contents.length) {
            this.preExpression = ParseTools.subset(this.contents, ++mark, this.contents.length - mark);
        }
    }

    public Object eval(TemplateRuntime runtime, TemplateOutputStream appender, Object ctx, VariableResolverFactory factory) {
        String file = MVEL.eval(this.includeExpression, ctx, factory, String.class);
        if (this.preExpression != null) {
            MVEL.eval(this.preExpression, ctx, factory);
        }
        if (this.next != null) {
            return this.next.eval(runtime, appender.append(String.valueOf(TemplateRuntime.eval(IncludeNode.readInFile(runtime, file), ctx, factory))), ctx, factory);
        }
        return appender.append(String.valueOf(MVEL.eval(IncludeNode.readInFile(runtime, file), ctx, factory)));
    }

    public boolean demarcate(Node terminatingNode, char[] template) {
        return false;
    }

    public static String readInFile(TemplateRuntime runtime, String fileName) {
        File file = new File(String.valueOf(runtime.getRelPath().peek()) + "/" + fileName);
        try {
            int read;
            FileInputStream instream = new FileInputStream(file);
            BufferedInputStream bufstream = new BufferedInputStream(instream);
            runtime.getRelPath().push(file.getParent());
            byte[] buf = new byte[10];
            StringBuilder appender = new StringBuilder();
            while ((read = bufstream.read(buf)) != -1) {
                for (int i = 0; i < read; ++i) {
                    appender.append((char)buf[i]);
                }
            }
            bufstream.close();
            instream.close();
            runtime.getRelPath().pop();
            return appender.toString();
        }
        catch (FileNotFoundException e) {
            throw new TemplateError("cannot include template '" + fileName + "': file not found.");
        }
        catch (IOException e) {
            throw new TemplateError("unknown I/O exception while including '" + fileName + "' (stacktrace nested)", e);
        }
    }
}

