/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.ErrorDetail;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessor;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.ArraySize;
import org.mvel2.ast.TypeDescriptor;
import org.mvel2.compiler.Accessor;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.compiler.PropertyVerifier;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.CompilerTools;
import org.mvel2.util.ErrorUtil;
import org.mvel2.util.ParseTools;

public class NewObjectNode
extends ASTNode {
    private transient Accessor newObjectOptimizer;
    private TypeDescriptor typeDescr;
    private char[] name;
    private static final Class[] EMPTYCLS = new Class[0];

    public NewObjectNode(TypeDescriptor typeDescr, int fields, ParserContext pCtx) {
        this.typeDescr = typeDescr;
        this.fields = fields;
        this.expr = typeDescr.getExpr();
        this.start = typeDescr.getStart();
        this.offset = typeDescr.getOffset();
        this.name = this.offset < this.expr.length ? ParseTools.subArray(this.expr, this.start, this.start + this.offset) : this.expr;
        if ((fields & 0x10) != 0) {
            if (pCtx != null && pCtx.hasImport(typeDescr.getClassName())) {
                pCtx.setAllowBootstrapBypass(false);
                this.egressType = pCtx.getImport(typeDescr.getClassName());
            } else {
                try {
                    this.egressType = Class.forName(typeDescr.getClassName(), true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    if (pCtx != null && pCtx.isStrongTyping()) {
                        pCtx.addError(new ErrorDetail(this.expr, this.start, true, "could not resolve class: " + typeDescr.getClassName()));
                    }
                    return;
                }
            }
            if (this.egressType != null) {
                this.rewriteClassReferenceToFQCN(fields);
                if (typeDescr.isArray()) {
                    try {
                        this.egressType = ParseTools.findClass(null, ParseTools.repeatChar('[', typeDescr.getArrayLength()) + "L" + this.egressType.getName() + ";", pCtx);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (pCtx != null && pCtx.isStrongTyping()) {
                if (this.egressType == null) {
                    pCtx.addError(new ErrorDetail(this.expr, this.start, true, "could not resolve class: " + typeDescr.getClassName()));
                    return;
                }
                if (!typeDescr.isArray()) {
                    String[] cnsResid = ParseTools.captureContructorAndResidual(this.expr, this.start, this.offset);
                    List<char[]> constructorParms = ParseTools.parseMethodOrConstructor(cnsResid[0].toCharArray());
                    Object[] parms = new Class[constructorParms.size()];
                    for (int i = 0; i < parms.length; ++i) {
                        parms[i] = MVEL.analyze(constructorParms.get(i), pCtx);
                    }
                    if (ParseTools.getBestConstructorCandidate((Class[])parms, this.egressType, true) == null && pCtx.isStrongTyping()) {
                        pCtx.addError(new ErrorDetail(this.expr, this.start, pCtx.isStrongTyping(), "could not resolve constructor " + typeDescr.getClassName() + Arrays.toString(parms)));
                    }
                    if (cnsResid.length == 2) {
                        String residualProperty = cnsResid[1].trim();
                        if (residualProperty.length() == 0) {
                            return;
                        }
                        this.egressType = new PropertyVerifier(residualProperty, pCtx, this.egressType).analyze();
                    }
                }
            }
        }
    }

    private void rewriteClassReferenceToFQCN(int fields) {
        String FQCN = this.egressType.getName();
        if (this.typeDescr.getClassName().indexOf(46) == -1) {
            int idx = ArrayTools.findFirst('(', 0, this.name.length, this.name);
            char[] fqcn = FQCN.toCharArray();
            if (idx == -1) {
                idx = fqcn.length;
                this.name = new char[idx];
                for (int i = 0; i < idx; ++i) {
                    this.name[i] = fqcn[i];
                }
            } else {
                char[] newName = new char[fqcn.length + (this.name.length - idx)];
                for (int i = 0; i < fqcn.length; ++i) {
                    newName[i] = fqcn[i];
                }
                int i0 = this.name.length - idx;
                int i1 = fqcn.length;
                for (int i = 0; i < i0; ++i) {
                    newName[i + i1] = this.name[i + idx];
                }
                this.name = newName;
            }
            this.typeDescr.updateClassName(this.name, 0, this.name.length, fields);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        block13: {
            Object object;
            if (this.newObjectOptimizer != null) return this.newObjectOptimizer.getValue(ctx, thisValue, factory);
            if (this.egressType == null && factory != null && factory.isResolveable(this.typeDescr.getClassName())) {
                try {
                    this.egressType = (Class)factory.getVariableResolver(this.typeDescr.getClassName()).getValue();
                    this.rewriteClassReferenceToFQCN(16);
                    if (this.typeDescr.isArray()) {
                        try {
                            this.egressType = ParseTools.findClass(factory, ParseTools.repeatChar('[', this.typeDescr.getArrayLength()) + "L" + this.egressType.getName() + ";", null);
                        }
                        catch (Exception e) {}
                    }
                }
                catch (ClassCastException e) {
                    throw new CompileException("cannot construct object: " + this.typeDescr.getClassName() + " is not a class reference", this.expr, this.start, e);
                }
            }
            if (this.typeDescr.isArray()) {
                this.newObjectOptimizer = new NewObjectArray(ParseTools.getBaseComponentType(this.egressType.getComponentType()), this.typeDescr.getCompiledArraySize());
                return this.newObjectOptimizer.getValue(ctx, thisValue, factory);
            }
            try {
                try {
                    AccessorOptimizer optimizer = OptimizerFactory.getThreadAccessorOptimizer();
                    ParserContext pCtx = new ParserContext();
                    pCtx.getParserConfiguration().setAllImports(CompilerTools.getInjectedImports(factory));
                    this.newObjectOptimizer = optimizer.optimizeObjectCreation(pCtx, this.name, 0, this.name.length, ctx, thisValue, factory);
                    if (optimizer.getResultOptPass() == null) break block13;
                    this.egressType = optimizer.getEgressType();
                    object = optimizer.getResultOptPass();
                    Object var8_10 = null;
                }
                catch (CompileException e) {
                    throw ErrorUtil.rewriteIfNeeded(e, this.expr, this.start);
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OptimizerFactory.clearThreadAccessorOptimizer();
                throw throwable;
            }
            OptimizerFactory.clearThreadAccessorOptimizer();
            return object;
        }
        Object var8_11 = null;
        OptimizerFactory.clearThreadAccessorOptimizer();
        return this.newObjectOptimizer.getValue(ctx, thisValue, factory);
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            if (this.typeDescr.isArray()) {
                Class cls = ParseTools.findClass(factory, this.typeDescr.getClassName(), null);
                int[] s = new int[this.typeDescr.getArrayLength()];
                ArraySize[] arraySize = this.typeDescr.getArraySize();
                for (int i = 0; i < s.length; ++i) {
                    s[i] = DataConversion.convert(MVEL.eval(arraySize[i].value, ctx, factory), Integer.class);
                }
                return Array.newInstance(cls, s);
            }
            String[] cnsRes = ParseTools.captureContructorAndResidual(this.name, 0, this.name.length);
            List<char[]> constructorParms = ParseTools.parseMethodOrConstructor(cnsRes[0].toCharArray());
            if (constructorParms != null) {
                Class cls = ParseTools.findClass(factory, new String(ParseTools.subset(this.name, 0, ArrayTools.findFirst('(', 0, this.name.length, this.name))).trim(), null);
                Object[] parms = new Object[constructorParms.size()];
                for (int i = 0; i < constructorParms.size(); ++i) {
                    parms[i] = MVEL.eval(constructorParms.get(i), ctx, factory);
                }
                Constructor cns = ParseTools.getBestConstructorCandidate(parms, cls, false);
                if (cns == null) {
                    throw new CompileException("unable to find constructor for: " + cls.getName(), this.expr, this.start);
                }
                for (int i = 0; i < parms.length; ++i) {
                    parms[i] = DataConversion.convert(parms[i], cns.getParameterTypes()[i]);
                }
                if (cnsRes.length > 1) {
                    return PropertyAccessor.get(cnsRes[1], cns.newInstance(parms), factory, thisValue);
                }
                return cns.newInstance(parms);
            }
            Constructor<?> cns = Class.forName(this.typeDescr.getClassName(), true, Thread.currentThread().getContextClassLoader()).getConstructor(EMPTYCLS);
            if (cnsRes.length > 1) {
                return PropertyAccessor.get(cnsRes[1], cns.newInstance(new Object[0]), factory, thisValue);
            }
            return cns.newInstance(new Object[0]);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new CompileException("unable to resolve class: " + e.getMessage(), this.expr, this.start, e);
        }
        catch (NoSuchMethodException e) {
            throw new CompileException("cannot resolve constructor: " + e.getMessage(), this.expr, this.start, e);
        }
        catch (Exception e) {
            throw new CompileException("could not instantiate class: " + e.getMessage(), this.expr, this.start, e);
        }
    }

    public TypeDescriptor getTypeDescr() {
        return this.typeDescr;
    }

    public static class NewObjectArray
    implements Accessor,
    Serializable {
        private ExecutableStatement[] sizes;
        private Class arrayType;

        public NewObjectArray(Class arrayType, ExecutableStatement[] sizes) {
            this.arrayType = arrayType;
            this.sizes = sizes;
        }

        public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
            int[] s = new int[this.sizes.length];
            for (int i = 0; i < s.length; ++i) {
                s[i] = DataConversion.convert(this.sizes[i].getValue(ctx, elCtx, variableFactory), Integer.class);
            }
            return Array.newInstance(this.arrayType, s);
        }

        public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
            return null;
        }

        public Class getKnownEgressType() {
            try {
                return Class.forName("[L" + this.arrayType.getName() + ";");
            }
            catch (ClassNotFoundException cne) {
                return null;
            }
        }
    }
}

