/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.PropertyAccessor;
import org.mvel2.ast.ASTNode;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizerFactory;

public class LiteralDeepPropertyNode
extends ASTNode {
    private Object literal;

    public LiteralDeepPropertyNode(char[] expr, int fields, Object literal) {
        this.fields = fields;
        this.name = expr;
        this.literal = literal;
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accessor != null) {
            return this.accessor.getValue(this.literal, thisValue, factory);
        }
        AccessorOptimizer aO = OptimizerFactory.getThreadAccessorOptimizer();
        this.accessor = aO.optimizeAccessor(AbstractParser.getCurrentThreadParserContext(), this.name, this.literal, thisValue, factory, false);
        return aO.getResultOptPass();
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return PropertyAccessor.get(this.name, this.literal, factory, thisValue);
    }
}

