/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.util.ParseTools;

public class CollectionParser {
    private char[] property;
    private int cursor;
    private int length;
    private int start;
    private int type;
    public static final int LIST = 0;
    public static final int ARRAY = 1;
    public static final int MAP = 2;
    private Class colType;
    private boolean strongType;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public CollectionParser() {
    }

    public CollectionParser(int type) {
        this.type = type;
    }

    public Object parseCollection(char[] property, boolean subcompile, boolean strongType) {
        this.cursor = 0;
        this.strongType = strongType;
        this.property = property;
        this.length = property.length;
        if (this.length > 0) {
            while (this.length > 0 && ParseTools.isWhitespace(property[this.length - 1])) {
                --this.length;
            }
        }
        return this.parseCollection(subcompile);
    }

    public Object parseCollection(char[] property, boolean subcompile, Class colType, boolean strongType) {
        if (colType != null) {
            this.colType = ParseTools.getBaseComponentType(colType);
        }
        this.cursor = 0;
        this.strongType = strongType;
        this.property = property;
        this.length = property.length;
        if (this.length > 0) {
            while (this.length > 0 && ParseTools.isWhitespace(property[this.length - 1])) {
                --this.length;
            }
        }
        return this.parseCollection(subcompile);
    }

    private Object parseCollection(boolean subcompile) {
        String ex;
        if (this.length == 0) {
            if (this.type == 0) {
                return new ArrayList();
            }
            return EMPTY_ARRAY;
        }
        HashMap<String, Object> map = null;
        ArrayList<Object> list = null;
        if (this.type != -1) {
            switch (this.type) {
                case 0: 
                case 1: {
                    list = new ArrayList<Object>();
                    break;
                }
                case 2: {
                    map = new HashMap<String, Object>();
                }
            }
        }
        Object curr = null;
        int newType = -1;
        while (this.cursor < this.length) {
            switch (this.property[this.cursor]) {
                case '{': {
                    if (newType == -1) {
                        newType = 1;
                    }
                }
                case '[': {
                    if (this.cursor > 0 && ParseTools.isIdentifierPart(this.property[this.cursor - 1])) break;
                    if (newType == -1) {
                        newType = 0;
                    }
                    this.start = this.cursor;
                    this.cursor = ParseTools.balancedCapture(this.property, this.start, this.property[this.start]);
                    Object o = new CollectionParser(newType).parseCollection(CollectionParser.subset(this.property, this.start + 1, this.cursor), subcompile, this.colType, this.strongType);
                    if (this.type == 2) {
                        map.put((String)curr, o);
                    } else {
                        curr = o;
                        list.add(curr);
                    }
                    this.start = ++this.cursor;
                    if (this.cursor >= this.length - 1 || this.property[this.cursor] != ',') break;
                    this.start = this.cursor + 1;
                    break;
                }
                case '(': {
                    this.cursor = ParseTools.balancedCapture(this.property, this.cursor, '(');
                    break;
                }
                case '\"': 
                case '\'': {
                    this.cursor = ParseTools.balancedCapture(this.property, this.cursor, this.property[this.cursor]);
                    break;
                }
                case ',': {
                    if (this.type != 2) {
                        ex = new String(this.property, this.start, this.cursor - this.start);
                        list.add(ex);
                    } else {
                        ex = ParseTools.createStringTrimmed(this.property, this.start, this.cursor - this.start);
                        map.put((String)curr, ex);
                    }
                    if (subcompile) {
                        this.subCompile(ex);
                    }
                    this.start = this.cursor + 1;
                    break;
                }
                case ':': {
                    if (this.type != 2) {
                        map = new HashMap();
                        this.type = 2;
                    }
                    curr = ParseTools.createStringTrimmed(this.property, this.start, this.cursor - this.start);
                    if (subcompile) {
                        this.subCompile((String)curr);
                    }
                    this.start = this.cursor + 1;
                    break;
                }
                case '.': {
                    ++this.cursor;
                    while (this.cursor != this.length && ParseTools.isWhitespace(this.property[this.cursor])) {
                        ++this.cursor;
                    }
                    if (this.cursor == this.length || this.property[this.cursor] != '{') break;
                    this.cursor = ParseTools.balancedCapture(this.property, this.cursor, '{');
                }
            }
            ++this.cursor;
        }
        if (this.start < this.length) {
            if (this.cursor < this.length - 1) {
                ++this.cursor;
            }
            if (this.type == 2) {
                ex = ParseTools.createStringTrimmed(this.property, this.start, this.cursor - this.start);
                map.put((String)curr, ex);
            } else {
                if (this.cursor < this.length) {
                    ++this.cursor;
                }
                ex = ParseTools.createStringTrimmed(this.property, this.start, this.cursor - this.start);
                list.add(ex);
            }
            if (subcompile) {
                this.subCompile(ex);
            }
        }
        switch (this.type) {
            case 2: {
                return map;
            }
            case 1: {
                return list.toArray();
            }
        }
        return list;
    }

    private void subCompile(String ex) {
        if (this.colType == null) {
            ParseTools.subCompileExpression(ex.toCharArray());
        } else {
            Class r = ((ExecutableStatement)ParseTools.subCompileExpression(ex.toCharArray())).getKnownEgressType();
            if (!(this.colType.isAssignableFrom(r) || !this.strongType && DataConversion.canConvert(r, this.colType))) {
                throw new CompileException("expected type: " + this.colType.getName() + "; but found:" + r.getName());
            }
        }
    }

    private static char[] subset(char[] property, int start, int end) {
        while (start < end - 1 && ParseTools.isWhitespace(property[start])) {
            ++start;
        }
        char[] newA = new char[end - start];
        for (int i = 0; i < newA.length; ++i) {
            newA[i] = property[i + start];
        }
        return newA;
    }

    public int getCursor() {
        return this.cursor;
    }
}

