/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl;

import java.lang.reflect.Array;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.integration.VariableResolverFactory;

public class ArrayAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private int index;

    public ArrayAccessor() {
    }

    public ArrayAccessor(int index) {
        this.index = index;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (this.nextNode != null) {
            return this.nextNode.getValue(Array.get(ctx, this.index), elCtx, vars);
        }
        return Array.get(ctx, this.index);
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        if (this.nextNode != null) {
            return this.nextNode.setValue(Array.get(ctx, this.index), elCtx, variableFactory, value);
        }
        Array.set(ctx, this.index, value);
        return value;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public Class getKnownEgressType() {
        return Object[].class;
    }

    public String toString() {
        return "Array Accessor -> [" + this.index + "]";
    }
}

