/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.mvel2.CompileException;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.integration.Interceptor;
import org.mvel2.util.MethodStub;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserConfiguration
implements Serializable {
    protected Map<String, Object> imports;
    protected Set<String> packageImports;
    protected Map<String, Interceptor> interceptors;
    protected transient ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public ParserConfiguration() {
    }

    public ParserConfiguration(Map<String, Object> imports, Map<String, Interceptor> interceptors) {
        if (imports != null) {
            this.imports = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : imports.entrySet()) {
                Object o = entry.getValue();
                if (o instanceof Method) {
                    this.imports.put(entry.getKey(), new MethodStub((Method)o));
                    continue;
                }
                this.imports.put(entry.getKey(), o);
            }
        }
        this.interceptors = interceptors;
    }

    public Set<String> getPackageImports() {
        return this.packageImports;
    }

    public void setPackageImports(Set<String> packageImports) {
        this.packageImports = packageImports;
    }

    public Class getImport(String name) {
        return this.imports != null && this.imports.containsKey(name) ? (Class)this.imports.get(name) : (Class)AbstractParser.LITERALS.get(name);
    }

    public MethodStub getStaticImport(String name) {
        return this.imports != null ? (MethodStub)this.imports.get(name) : null;
    }

    public Object getStaticOrClassImport(String name) {
        return this.imports != null && this.imports.containsKey(name) ? this.imports.get(name) : AbstractParser.LITERALS.get(name);
    }

    public void addPackageImport(String packageName) {
        if (this.packageImports == null) {
            this.packageImports = new HashSet<String>();
        }
        this.packageImports.add(packageName);
    }

    private boolean checkForDynamicImport(String className) {
        if (this.packageImports == null) {
            return false;
        }
        int found = 0;
        Class<?> cls = null;
        for (String pkg : this.packageImports) {
            try {
                cls = this.classLoader.loadClass(pkg + "." + className);
                ++found;
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
                if (PropertyTools.contains(e.getMessage(), "wrong name")) continue;
                throw e;
            }
        }
        if (found > 1) {
            throw new CompileException("ambiguous class name: " + className);
        }
        if (found == 1) {
            this.addImport(className, cls);
            return true;
        }
        return false;
    }

    public boolean hasImport(String name) {
        return this.imports != null && this.imports.containsKey(name) || !"this".equals(name) && !"self".equals(name) && !"empty".equals(name) && !"null".equals(name) && !"nil".equals(name) && !"true".equals(name) && !"false".equals(name) && AbstractParser.LITERALS.containsKey(name) || this.checkForDynamicImport(name);
    }

    public void addImport(Class cls) {
        this.addImport(ParseTools.getSimpleClassName(cls), cls);
    }

    public void addImport(String name, Class cls) {
        if (this.imports == null) {
            this.imports = new LinkedHashMap<String, Object>();
        }
        this.imports.put(name, cls);
    }

    public void addImport(String name, Method method) {
        this.addImport(name, new MethodStub(method));
    }

    public void addImport(String name, MethodStub method) {
        if (this.imports == null) {
            this.imports = new LinkedHashMap<String, Object>();
        }
        this.imports.put(name, method);
    }

    public Map<String, Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(Map<String, Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public Map<String, Object> getImports() {
        return this.imports;
    }

    public void setImports(Map<String, Object> imports) {
        if (imports == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : imports.entrySet()) {
            Object val = entry.getValue();
            if (val instanceof Class) {
                this.addImport(entry.getKey(), (Class)val);
                continue;
            }
            if (val instanceof Method) {
                this.addImport(entry.getKey(), (Method)val);
                continue;
            }
            if (val instanceof MethodStub) {
                this.addImport(entry.getKey(), (MethodStub)val);
                continue;
            }
            throw new RuntimeException("invalid element in imports map: " + entry.getKey() + " (" + val + ")");
        }
    }

    public boolean hasImports() {
        return this.imports != null && this.imports.size() != 0 || this.packageImports != null && this.packageImports.size() != 0;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

