/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.mvel2.CompileException;
import org.mvel2.OptimizationFailure;
import org.mvel2.PropertyAccessException;
import org.mvel2.PropertyAccessor;
import org.mvel2.UnresolveablePropertyException;
import org.mvel2.ast.Function;
import org.mvel2.ast.TypeDescriptor;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.Accessor;
import org.mvel2.debug.DebugTools;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizationNotSupported;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.ParseTools;
import org.mvel2.util.ThisLiteral;

public class ASTNode
implements Cloneable,
Serializable {
    public static final int LITERAL = 1;
    public static final int DEEP_PROPERTY = 2;
    public static final int OPERATOR = 4;
    public static final int IDENTIFIER = 8;
    public static final int COMPILE_IMMEDIATE = 16;
    public static final int NUMERIC = 32;
    public static final int NEGATION = 64;
    public static final int INVERT = 128;
    public static final int FOLD = 256;
    public static final int METHOD = 512;
    public static final int ASSIGN = 1024;
    public static final int LOOKAHEAD = 2048;
    public static final int COLLECTION = 4096;
    public static final int THISREF = 8192;
    public static final int INLINE_COLLECTION = 16384;
    public static final int STR_LITERAL = 32768;
    public static final int BLOCK_IF = 65536;
    public static final int BLOCK_FOREACH = 131072;
    public static final int BLOCK_WITH = 262144;
    public static final int BLOCK_UNTIL = 524288;
    public static final int BLOCK_WHILE = 0x100000;
    public static final int BLOCK_DO = 0x200000;
    public static final int BLOCK_DO_UNTIL = 0x400000;
    public static final int BLOCK_FOR = 0x800000;
    public static final int INTEGER32 = 0x1000000;
    public static final int NOJIT = 0x2000000;
    public static final int DEOP = 0x4000000;
    protected int firstUnion;
    protected int endOfName;
    public int fields = 0;
    protected Class egressType;
    protected char[] name;
    protected String nameCache;
    protected Object literal;
    protected volatile transient Accessor accessor;
    protected volatile Accessor safeAccessor;
    protected int cursorPosition;
    public ASTNode nextASTNode;
    protected boolean discard;
    protected int intRegister;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accessor != null) {
            try {
                return this.accessor.getValue(ctx, thisValue, factory);
            }
            catch (ClassCastException ce) {
                if ((this.fields & 0x4000000) == 0) {
                    this.accessor = null;
                    this.fields |= 0x6000000;
                    ASTNode aSTNode = this;
                    synchronized (aSTNode) {
                        return this.getReducedValueAccelerated(ctx, thisValue, factory);
                    }
                }
                throw ce;
            }
        }
        if ((this.fields & 0x4000000) != 0) {
            this.fields ^= 0x4000000;
        }
        Object retVal = null;
        AccessorOptimizer optimizer = (this.fields & 0x2000000) != 0 ? OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE) : OptimizerFactory.getDefaultAccessorCompiler();
        try {
            this.setAccessor(optimizer.optimizeAccessor(AbstractParser.getCurrentThreadParserContext(), this.name, ctx, thisValue, factory, true));
        }
        catch (OptimizationNotSupported ne) {
            optimizer = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
            this.setAccessor(optimizer.optimizeAccessor(AbstractParser.getCurrentThreadParserContext(), this.name, ctx, thisValue, factory, true));
        }
        if (this.accessor == null) {
            throw new OptimizationFailure("failed optimization");
        }
        if (retVal == null) {
            retVal = optimizer.getResultOptPass();
        }
        if (this.egressType == null) {
            this.egressType = optimizer.getEgressType();
        }
        return retVal;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if ((this.fields & 1) != 0) {
            return this.literal;
        }
        if ((this.fields & 2) != 0) {
            String s = this.getAbsoluteRootElement();
            if (AbstractParser.LITERALS.containsKey(s)) {
                return PropertyAccessor.get(this.getAbsoluteRemainder(), AbstractParser.LITERALS.get(s), factory, thisValue);
            }
            if (factory != null && factory.isResolveable(s)) {
                return PropertyAccessor.get(this.name, ctx, factory, thisValue);
            }
            if (ctx != null) {
                try {
                    return PropertyAccessor.get(this.name, ctx, factory, thisValue);
                }
                catch (PropertyAccessException e) {
                    this.literal = this.tryStaticAccess(ctx, factory);
                    if (this.literal == null) {
                        throw e;
                    }
                    this.fields |= 1;
                    return this.literal;
                }
            }
        } else {
            String s;
            if (factory != null && factory.isResolveable(s = this.getAbsoluteName())) {
                if (this.isCollection()) {
                    return PropertyAccessor.get(new String(this.name, this.endOfName, this.name.length - this.endOfName), factory.getVariableResolver(s).getValue(), factory, thisValue);
                }
                return factory.getVariableResolver(s).getValue();
            }
            if (ctx != null) {
                try {
                    return PropertyAccessor.get(this.name, ctx, factory, thisValue);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            if (this.isOperator()) {
                throw new CompileException("incomplete statement: " + new String(this.name));
            }
            TypeDescriptor td = new TypeDescriptor(this.name, 0);
            if (td.isArray()) {
                try {
                    this.fields |= 1;
                    this.literal = TypeDescriptor.getClassReference(AbstractParser.getCurrentThreadParserContext(), td);
                    return this.literal;
                }
                catch (Exception e) {}
            } else if (factory != null && factory.isResolveable(td.getClassName())) {
                Object o = factory.getVariableResolver(td.getClassName()).getValue();
                if (o instanceof Method) {
                    Method m = (Method)o;
                    return PropertyAccessor.get(m.getName() + new String(this.name, td.getEndRange(), this.name.length - td.getEndRange()), m.getDeclaringClass(), factory, thisValue);
                }
                if (o instanceof Function) {
                    Function f = (Function)o;
                    return PropertyAccessor.get(f.getName() + new String(this.name, td.getEndRange(), this.name.length - td.getEndRange()), null, factory, thisValue);
                }
                throw new CompileException("call to non-callable object: " + o.getClass().getName());
            }
            throw new CompileException("cannot resolve identifier: " + new String(this.name));
        }
        this.literal = this.tryStaticAccess(ctx, factory);
        if (this.literal == null) {
            throw new UnresolveablePropertyException(this);
        }
        this.fields |= 1;
        return this.literal;
    }

    protected String getAbsoluteRootElement() {
        if ((this.fields & 0x1002) != 0) {
            return new String(this.name, 0, this.getAbsoluteFirstPart());
        }
        return this.nameCache;
    }

    public Class getEgressType() {
        return this.egressType;
    }

    public void setEgressType(Class egressType) {
        this.egressType = egressType;
    }

    protected String getAbsoluteRemainder() {
        return (this.fields & 0x1000) != 0 ? new String(this.name, this.endOfName, this.name.length - this.endOfName) : ((this.fields & 2) != 0 ? new String(this.name, this.firstUnion + 1, this.name.length - this.firstUnion - 1) : null);
    }

    public char[] getNameAsArray() {
        return this.name;
    }

    private int getAbsoluteFirstPart() {
        if ((this.fields & 0x1000) != 0) {
            if (this.firstUnion < 0 || this.endOfName < this.firstUnion) {
                return this.endOfName;
            }
            return this.firstUnion;
        }
        if ((this.fields & 2) != 0) {
            return this.firstUnion;
        }
        return -1;
    }

    public String getAbsoluteName() {
        if ((this.fields & 0x1002) != 0) {
            return new String(this.name, 0, this.getAbsoluteFirstPart());
        }
        return this.getName();
    }

    public String getName() {
        if (this.nameCache != null) {
            return this.nameCache;
        }
        if (this.name != null) {
            this.nameCache = new String(this.name);
            return this.nameCache;
        }
        return "";
    }

    public Object getLiteralValue() {
        return this.literal;
    }

    public void setLiteralValue(Object literal) {
        this.literal = literal;
        this.fields |= 1;
    }

    protected Object tryStaticAccess(Object thisRef, VariableResolverFactory factory) {
        try {
            boolean meth = false;
            int depth = 0;
            int last = this.name.length;
            block9: for (int i = last - 1; i > 0; --i) {
                switch (this.name[i]) {
                    case '.': {
                        if (depth == 0 && !meth) {
                            try {
                                return PropertyAccessor.get(new String(this.name, last, this.name.length - last), Thread.currentThread().getContextClassLoader().loadClass(new String(this.name, 0, last)), factory, thisRef);
                            }
                            catch (ClassNotFoundException e) {
                                return PropertyAccessor.get(new String(this.name, i + 1, this.name.length - i - 1), Thread.currentThread().getContextClassLoader().loadClass(new String(this.name, 0, i)), factory, thisRef);
                            }
                        }
                        meth = false;
                        last = i;
                        continue block9;
                    }
                    case ')': {
                        ++depth;
                        continue block9;
                    }
                    case '(': {
                        if (--depth != 0) continue block9;
                        meth = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void setName(char[] name) {
        this.name = name;
        this.literal = new String(name);
        if (AbstractParser.LITERALS.containsKey(this.literal)) {
            this.fields |= 9;
            this.literal = AbstractParser.LITERALS.get(this.literal);
            if (this.literal == ThisLiteral.class) {
                this.fields |= 0x2000;
            }
            if (this.literal != null) {
                this.egressType = this.literal.getClass();
            }
        } else {
            if (AbstractParser.OPERATORS.containsKey(this.literal)) {
                this.fields |= 4;
                this.literal = AbstractParser.OPERATORS.get(this.literal);
                this.egressType = this.literal.getClass();
                return;
            }
            if (ParseTools.isNumber(name)) {
                this.literal = ParseTools.handleNumericConversion(name);
                this.egressType = this.literal.getClass();
                if (((this.fields |= 0x29) & 0x80) != 0) {
                    try {
                        this.literal = ~((Integer)this.literal).intValue();
                    }
                    catch (ClassCastException e) {
                        throw new CompileException("bitwise (~) operator can only be applied to integers");
                    }
                }
                if (this.literal instanceof Integer) {
                    this.intRegister = (Integer)this.literal;
                    this.fields |= 0x1000000;
                }
                return;
            }
            if ((this.fields & 0x4000) != 0) {
                return;
            }
            this.firstUnion = ArrayTools.findFirst('.', name);
            this.fields = this.firstUnion > 0 ? ((this.fields & 0x200) != 0 ? (this.firstUnion < ArrayTools.findFirst('(', name) ? (this.fields |= 0xA) : (this.fields |= 8)) : (this.fields |= 0xA)) : (this.fields |= 8);
        }
        if ((this.endOfName = ArrayTools.findFirst('[', name)) > 0) {
            this.fields |= 0x1000;
        }
    }

    public Accessor setAccessor(Accessor accessor) {
        this.accessor = accessor;
        return this.accessor;
    }

    public boolean isIdentifier() {
        return (this.fields & 8) != 0;
    }

    public boolean isLiteral() {
        return (this.fields & 1) != 0;
    }

    public boolean isThisVal() {
        return (this.fields & 0x2000) != 0;
    }

    public boolean isOperator() {
        return (this.fields & 4) != 0;
    }

    public boolean isOperator(Integer operator) {
        return (this.fields & 4) != 0 && operator.equals(this.literal);
    }

    public Integer getOperator() {
        return -1;
    }

    protected boolean isCollection() {
        return (this.fields & 0x1000) != 0;
    }

    public boolean isAssignment() {
        return (this.fields & 0x400) != 0;
    }

    public boolean isDeepProperty() {
        return (this.fields & 2) != 0;
    }

    public void setAsLiteral() {
        this.fields |= 1;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public void setDiscard(boolean discard) {
        this.discard = discard;
    }

    public void discard() {
        this.discard = true;
    }

    public boolean isDebuggingSymbol() {
        return this.fields == -1;
    }

    public int getIntRegister() {
        return this.intRegister;
    }

    public void setIntRegister(int intRegister) {
        this.intRegister = intRegister;
    }

    public int getFields() {
        return this.fields;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public boolean canSerializeAccessor() {
        return this.safeAccessor != null;
    }

    public ASTNode() {
    }

    public ASTNode(char[] expr, int start, int end, int fields) {
        this.fields = fields;
        this.cursorPosition = start;
        char[] name = new char[end - this.cursorPosition];
        for (int i = 0; i < name.length; ++i) {
            name[i] = expr[i + start];
        }
        this.setName(name);
    }

    public ASTNode(char[] expr, int fields) {
        this.fields = fields;
        this.name = expr;
    }

    public String toString() {
        return this.isOperator() ? "<<" + DebugTools.getOperatorName(this.getOperator()) + ">>" : String.valueOf(this.literal);
    }
}

